/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.document.ResourceCollectionDocument;
import cloud.codestore.jsonapi.document.SingleResourceDocument;
import cloud.codestore.jsonapi.internal.RelationshipHolder;
import cloud.codestore.jsonapi.relationship.Relationship;
import cloud.codestore.jsonapi.relationship.ToManyRelationship;
import cloud.codestore.jsonapi.relationship.ToOneRelationship;
import cloud.codestore.jsonapi.resource.ResourceIdentifierObject;
import cloud.codestore.jsonapi.resource.ResourceObject;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class JsonApiDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDescription, JsonDeserializer<?> deserializer) {
        Class beanClass = beanDescription.getBeanClass();
        if (JsonApiDeserializerModifier.isSingleResourceDocument(beanClass) || JsonApiDeserializerModifier.isResourceCollectionDocument(beanClass)) {
            return new DocumentDeserializer(deserializer);
        }
        return deserializer;
    }

    private static boolean isSingleResourceDocument(Class<?> type) {
        return SingleResourceDocument.class.isAssignableFrom(type);
    }

    private static boolean isResourceCollectionDocument(Class<?> type) {
        return ResourceCollectionDocument.class.isAssignableFrom(type);
    }

    private static class DocumentDeserializer
    extends DelegatingDeserializer {
        DocumentDeserializer(JsonDeserializer<?> deserializer) {
            super(deserializer);
        }

        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
            return new DocumentDeserializer(jsonDeserializer);
        }

        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            RelationshipHolder.reset();
            List<ResourceObject> includedResources = Collections.emptyList();
            Object object = super.deserialize(parser, context);
            if (object instanceof SingleResourceDocument) {
                SingleResourceDocument document = (SingleResourceDocument)object;
                includedResources = document.getIncludedResources();
            } else if (object instanceof ResourceCollectionDocument) {
                ResourceCollectionDocument document = (ResourceCollectionDocument)object;
                includedResources = document.getIncludedResources();
            }
            if (!includedResources.isEmpty()) {
                for (Relationship relationship : RelationshipHolder.getRelationships()) {
                    this.bindIncludedResourcesToRelationships(includedResources, relationship);
                }
            }
            return object;
        }

        private void bindIncludedResourcesToRelationships(List<ResourceObject> includedResources, Relationship relationship) {
            if (relationship instanceof ToOneRelationship) {
                ToOneRelationship toOneRelationship = (ToOneRelationship)relationship;
                this.bindIncludedResourcesToRelationship(includedResources, toOneRelationship);
            } else if (relationship instanceof ToManyRelationship) {
                ToManyRelationship toManyRelationship = (ToManyRelationship)relationship;
                this.bindIncludedResourcesToRelationship(includedResources, toManyRelationship);
            }
        }

        private void bindIncludedResourcesToRelationship(List<ResourceObject> includedResources, ToOneRelationship relationship) {
            ResourceIdentifierObject identifier = relationship.getData();
            for (ResourceObject resourceObject : includedResources) {
                if (!Objects.equals(identifier, resourceObject.getIdentifier())) continue;
                relationship.setRelatedResource(resourceObject);
                return;
            }
        }

        private void bindIncludedResourcesToRelationship(List<ResourceObject> includedResources, ToManyRelationship relationship) {
            ArrayList<ResourceObject> relatedObjects = new ArrayList<ResourceObject>();
            for (ResourceIdentifierObject identifier : relationship.getData()) {
                for (ResourceObject resourceObject : includedResources) {
                    if (!Objects.equals(identifier, resourceObject.getIdentifier())) continue;
                    relatedObjects.add(resourceObject);
                }
            }
            relationship.setRelatedResource(relatedObjects.toArray(new ResourceObject[0]));
        }
    }
}

