/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.document.JsonApiDocument;
import cloud.codestore.jsonapi.document.ResourceCollectionDocument;
import cloud.codestore.jsonapi.document.SingleResourceDocument;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonApiDocumentDeserializer
extends StdDeserializer<JsonApiDocument> {
    public JsonApiDocumentDeserializer() {
        super(JsonApiDocument.class);
    }

    public JsonApiDocument deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode relationshipNode = (ObjectNode)mapper.readTree(jsonParser);
        if (relationshipNode.has("data")) {
            JsonNode dataNode = relationshipNode.get("data");
            if (dataNode.isObject()) {
                return (JsonApiDocument)mapper.treeToValue((TreeNode)relationshipNode, SingleResourceDocument.class);
            }
            if (dataNode.isArray()) {
                return (JsonApiDocument)mapper.treeToValue((TreeNode)relationshipNode, ResourceCollectionDocument.class);
            }
        }
        return (JsonApiDocument)mapper.treeToValue((TreeNode)relationshipNode, SingleResourceDocument.class);
    }
}

