/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.link.Link;
import cloud.codestore.jsonapi.link.LinksObject;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class LinksObjectDeserializer
extends StdDeserializer<LinksObject> {
    public LinksObjectDeserializer() {
        super(LinksObject.class);
    }

    public LinksObject deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        LinksObject linksObject = new LinksObject();
        JsonToken token = jsonParser.nextToken();
        while (token != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                String relation = jsonParser.getText();
                token = jsonParser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    String href = jsonParser.getText();
                    linksObject.add(new Link(relation, href));
                } else {
                    Link tmp = (Link)jsonParser.readValueAs(Link.class);
                    Link link = new Link(relation, tmp.getHref(), tmp.getMeta());
                    linksObject.add(link);
                }
            }
            token = jsonParser.nextToken();
        }
        return linksObject;
    }
}

