/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.meta.MetaDeserializer;
import cloud.codestore.jsonapi.meta.MetaInformation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class MetaInformationDeserializer
extends StdDeserializer<MetaInformation> {
    private MetaDeserializer metaDeserializer;

    public MetaInformationDeserializer(MetaDeserializer metaDeserializer) {
        super(MetaInformation.class);
        this.metaDeserializer = metaDeserializer;
    }

    public MetaInformation deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        if (this.metaDeserializer == null) {
            return null;
        }
        JsonStreamContext parsingContext = jsonParser.getParsingContext();
        String pointer = parsingContext.pathAsPointer().toString();
        Class<? extends MetaInformation> metaInformationClass = this.metaDeserializer.getClass(pointer = this.addRelationshipPath(pointer));
        if (metaInformationClass == null) {
            return this.readFromTree(jsonParser, pointer, (ObjectNode)jsonParser.readValueAsTree());
        }
        return (MetaInformation)jsonParser.readValueAs(metaInformationClass);
    }

    private String addRelationshipPath(String pointer) {
        if (pointer.startsWith("/data/")) {
            return this.insertRelationshipAfter("/data/", pointer);
        }
        if (pointer.startsWith("/included/")) {
            return this.insertRelationshipAfter("/included/", pointer);
        }
        return pointer;
    }

    private String insertRelationshipAfter(String start, String pointer) {
        String subPointer = pointer.replaceFirst(start + "(\\d+/)?", "");
        if (!subPointer.startsWith("meta") && !subPointer.startsWith("links")) {
            pointer = pointer.replace(subPointer, "relationships/" + subPointer);
        }
        return pointer;
    }

    private MetaInformation readFromTree(JsonParser jsonParser, String pointer, ObjectNode node) throws JsonParseException {
        try {
            return this.metaDeserializer.deserialize(pointer, node);
        }
        catch (Exception exception) {
            throw new JsonParseException(jsonParser, "Failed to deserialize JSON:API meta object.", (Throwable)exception);
        }
    }
}

