/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.relationship.Relationship;
import cloud.codestore.jsonapi.relationship.ToManyRelationship;
import cloud.codestore.jsonapi.relationship.ToOneRelationship;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class RelationshipDeserializer
extends StdDeserializer<Relationship> {
    public RelationshipDeserializer() {
        super(Relationship.class);
    }

    public Relationship deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode relationshipNode = (ObjectNode)mapper.readTree(jsonParser);
        if (relationshipNode.has("data")) {
            JsonNode dataNode = relationshipNode.get("data");
            if (dataNode.isObject()) {
                return (Relationship)mapper.treeToValue((TreeNode)relationshipNode, ToOneRelationship.class);
            }
            if (dataNode.isArray()) {
                return (Relationship)mapper.treeToValue((TreeNode)relationshipNode, ToManyRelationship.class);
            }
        }
        return (Relationship)mapper.treeToValue((TreeNode)relationshipNode, ToOneRelationship.class);
    }
}

