/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.document.JsonApiDocument;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ResourceObjectDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDescription, JsonDeserializer<?> deserializer) {
        if (ResourceObjectDeserializerModifier.isJsonApiDocument(beanDescription.getBeanClass())) {
            return new FieldUnwrappingDeserializer(deserializer);
        }
        return deserializer;
    }

    private static boolean isJsonApiDocument(Class<?> type) {
        return JsonApiDocument.class.isAssignableFrom(type);
    }

    private static class FieldUnwrappingDeserializer
    extends DelegatingDeserializer {
        FieldUnwrappingDeserializer(JsonDeserializer<?> deserializer) {
            super(deserializer);
        }

        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
            return new FieldUnwrappingDeserializer(jsonDeserializer);
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return super.deserialize(this.unwrapAttributesAndRelationships(jsonParser), context);
        }

        private JsonParser unwrapAttributesAndRelationships(JsonParser jsonParser) throws IOException {
            ObjectNode rootNode = (ObjectNode)jsonParser.readValueAsTree();
            this.visit(rootNode);
            JsonParser newJsonParser = jsonParser.getCodec().treeAsTokens((TreeNode)rootNode);
            newJsonParser.nextToken();
            return newJsonParser;
        }

        private void visit(JsonNode node) {
            if (node.isObject()) {
                this.visit((ObjectNode)node);
            } else if (node.isArray()) {
                this.visit((ArrayNode)node);
            }
        }

        private void visit(ObjectNode node) {
            if (node.has("attributes") || node.has("relationships")) {
                this.unwrap(node, "attributes");
                this.unwrap(node, "relationships");
            } else {
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    if ("meta".equals(field.getKey())) continue;
                    this.visit((JsonNode)field.getValue());
                }
            }
        }

        private void visit(ArrayNode jsonArray) {
            for (JsonNode field : jsonArray) {
                this.visit(field);
            }
        }

        private void unwrap(ObjectNode node, String key) {
            if (node.has(key)) {
                Iterator fields = node.get(key).fields();
                while (fields.hasNext()) {
                    Map.Entry entry = (Map.Entry)fields.next();
                    node.set((String)entry.getKey(), (JsonNode)entry.getValue());
                }
                node.remove(key);
            }
        }
    }
}

