/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.internal;

import cloud.codestore.jsonapi.internal.VirtualAttributesWriter;
import cloud.codestore.jsonapi.internal.VirtualRelationshipsWriter;
import cloud.codestore.jsonapi.relationship.Relationship;
import cloud.codestore.jsonapi.resource.ResourceObject;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ResourceObjectSerializerModifier
extends BeanSerializerModifier {
    private static final List<String> PREDEFINED_FIELDS = Arrays.asList("type", "id", "attributes", "relationships", "links", "meta");

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> properties) {
        if (ResourceObjectSerializerModifier.isResourceObject(beanDesc.getBeanClass())) {
            LinkedList<BeanPropertyWriter> attributes = new LinkedList<BeanPropertyWriter>();
            VirtualAttributesWriter attributesWriter = null;
            LinkedList<BeanPropertyWriter> relationships = new LinkedList<BeanPropertyWriter>();
            VirtualRelationshipsWriter relationshipsWriter = null;
            for (int i = properties.size() - 1; i >= 0; --i) {
                BeanPropertyWriter property = properties.get(i);
                String propertyName = property.getName();
                if (PREDEFINED_FIELDS.contains(propertyName)) {
                    if ("attributes".equals(propertyName) && property instanceof VirtualAttributesWriter) {
                        attributesWriter = (VirtualAttributesWriter)property;
                        continue;
                    }
                    if (!"relationships".equals(propertyName) || !(property instanceof VirtualRelationshipsWriter)) continue;
                    relationshipsWriter = (VirtualRelationshipsWriter)property;
                    continue;
                }
                if (ResourceObjectSerializerModifier.isRelationship(property.getMember().getRawType())) {
                    relationships.add(property);
                } else {
                    attributes.add(property);
                }
                properties.remove(i);
            }
            if (attributesWriter != null) {
                attributesWriter.setAttributeProperties(attributes);
            }
            if (relationshipsWriter != null) {
                relationshipsWriter.setRelationshipProperties(relationships);
            }
        }
        return properties;
    }

    public List<BeanPropertyWriter> orderProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (ResourceObjectSerializerModifier.isResourceObject(beanDesc.getBeanClass())) {
            BeanPropertyWriter[] orderedList = new BeanPropertyWriter[PREDEFINED_FIELDS.size()];
            for (BeanPropertyWriter property : beanProperties) {
                int index = PREDEFINED_FIELDS.indexOf(property.getName());
                orderedList[index] = property;
            }
            return Arrays.asList(orderedList);
        }
        return super.orderProperties(config, beanDesc, beanProperties);
    }

    private static boolean isResourceObject(Class<?> type) {
        return ResourceObject.class.isAssignableFrom(type);
    }

    private static boolean isRelationship(Class<?> type) {
        return Relationship.class.isAssignableFrom(type);
    }
}

