/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.link;

import cloud.codestore.jsonapi.internal.LinkSerializer;
import cloud.codestore.jsonapi.meta.MetaInformation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

@JsonSerialize(using=LinkSerializer.class)
public class Link {
    public static final String SELF = "self";
    public static final String RELATED = "related";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    public static final String PREV = "prev";
    public static final String NEXT = "next";
    public static final String ABOUT = "about";
    private String relation;
    private String href;
    private MetaInformation meta;

    @JsonCreator
    Link(@JsonProperty(value="href") String href, @JsonProperty(value="meta") MetaInformation meta) {
        this.relation = null;
        this.href = href;
        this.meta = meta;
    }

    public Link(String relation, String href) {
        this(relation, href, null);
    }

    public Link(String relation, String href, MetaInformation meta) {
        if (relation == null || relation.isBlank()) {
            throw new IllegalArgumentException("Parameter 'relation' must not be null or blank.");
        }
        if (href == null || href.isBlank()) {
            throw new IllegalArgumentException("Parameter 'href' must not be null or blank.");
        }
        this.relation = relation;
        this.href = href;
        this.meta = meta;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getHref() {
        return this.href;
    }

    public MetaInformation getMeta() {
        return this.meta;
    }

    @JsonSetter(value="meta")
    public Link setMeta(MetaInformation meta) {
        this.meta = meta;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Link link = (Link)obj;
        return Objects.equals(this.relation, link.relation) && Objects.equals(this.href, link.href);
    }

    public int hashCode() {
        return Objects.hash(this.relation, this.href);
    }
}

