/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.link;

import cloud.codestore.jsonapi.internal.LinksObjectDeserializer;
import cloud.codestore.jsonapi.link.Link;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=LinksObjectDeserializer.class)
public class LinksObject {
    private final Map<String, Link> links = new HashMap<String, Link>();

    public LinksObject add(Link link) {
        Objects.requireNonNull(link);
        this.links.put(link.getRelation(), link);
        return this;
    }

    public Link get(String relation) {
        return this.links.get(relation);
    }

    public List<Link> asList() {
        LinkedList<Link> list = new LinkedList<Link>(this.links.values());
        return Collections.unmodifiableList(list);
    }

    public String getSelfLink() {
        return this.links.containsKey("self") ? this.links.get("self").getHref() : null;
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    @JsonValue
    Map<String, Link> getLinks() {
        return this.isEmpty() ? null : Collections.unmodifiableMap(this.links);
    }
}

