/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.relationship;

import cloud.codestore.jsonapi.internal.RelationshipDeserializer;
import cloud.codestore.jsonapi.link.Link;
import cloud.codestore.jsonapi.link.LinksObject;
import cloud.codestore.jsonapi.meta.MetaInformation;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(using=RelationshipDeserializer.class)
public class Relationship {
    private LinksObject links = new LinksObject();
    private MetaInformation meta;

    public Relationship() {
    }

    public Relationship(String relatedResourceLink) {
        this.setRelatedResourceLink(relatedResourceLink);
    }

    public Relationship setSelfLink(String link) {
        this.links = Objects.requireNonNullElseGet(this.links, LinksObject::new);
        this.links.add(new Link("self", link));
        return this;
    }

    public Relationship setRelatedResourceLink(String relatedResourceLink) {
        this.links.add(new Link("related", relatedResourceLink));
        return this;
    }

    @JsonGetter(value="links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    public LinksObject getLinks() {
        return this.links;
    }

    @JsonGetter(value="meta")
    public MetaInformation getMeta() {
        return this.meta;
    }

    @JsonSetter(value="meta")
    public Relationship setMeta(MetaInformation meta) {
        this.meta = meta;
        return this;
    }

    @JsonIgnore
    public boolean isIncluded() {
        return false;
    }
}

