/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.relationship;

import cloud.codestore.jsonapi.internal.DeserializedToManyRelationship;
import cloud.codestore.jsonapi.relationship.Relationship;
import cloud.codestore.jsonapi.resource.ResourceIdentifierObject;
import cloud.codestore.jsonapi.resource.ResourceObject;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Array;
import java.util.Arrays;

@JsonDeserialize(as=DeserializedToManyRelationship.class)
public class ToManyRelationship
extends Relationship {
    private ResourceIdentifierObject[] data;
    private ResourceObject[] relatedResource;

    public ToManyRelationship() {
    }

    public ToManyRelationship(String relatedResourceLink) {
        super(relatedResourceLink);
    }

    public ToManyRelationship(ResourceObject[] resourceObject) {
        this.setRelatedResource(resourceObject);
    }

    @JsonIgnore
    public ToManyRelationship setRelatedResource(ResourceObject[] resourceObjects) {
        this.relatedResource = resourceObjects;
        if (this.isIncluded()) {
            ResourceIdentifierObject[] resourceIdentifiers = (ResourceIdentifierObject[])Arrays.stream(resourceObjects).map(ResourceObject::getIdentifier).toArray(ResourceIdentifierObject[]::new);
            this.setData(resourceIdentifiers);
        } else {
            this.setData(null);
        }
        return this;
    }

    @JsonIgnore
    public ResourceObject[] getRelatedResource() {
        return this.relatedResource;
    }

    @JsonIgnore
    public <T extends ResourceObject> T[] getRelatedResource(Class<T> type) {
        if (this.relatedResource == null) {
            return null;
        }
        return (ResourceObject[])Arrays.stream(this.relatedResource).map(resourceObject -> {
            if (resourceObject.getClass().isAssignableFrom(type)) {
                return resourceObject;
            }
            throw new ClassCastException(resourceObject.getClass() + " cannot be cast to " + type);
        }).toArray(value -> (ResourceObject[])Array.newInstance(type, this.relatedResource.length));
    }

    @JsonGetter(value="data")
    public ResourceIdentifierObject[] getData() {
        return this.data;
    }

    @JsonSetter(value="data")
    public ToManyRelationship setData(ResourceIdentifierObject[] data) {
        if (this.relatedResource != null && !this.relatedResourceCountMatchesResourceIdentifierCount(data)) {
            throw new IllegalStateException("Relationships that contain related resources must contain a resource identifier objects to provide resource linkage.");
        }
        this.data = data;
        return this;
    }

    @Override
    public boolean isIncluded() {
        return this.relatedResource != null && this.relatedResource.length > 0;
    }

    private boolean relatedResourceCountMatchesResourceIdentifierCount(ResourceIdentifierObject[] resourceIdentifiers) {
        return this.relatedResource != null && resourceIdentifiers != null && this.relatedResource.length == resourceIdentifiers.length;
    }
}

