/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.relationship;

import cloud.codestore.jsonapi.internal.DeserializedToOneRelationship;
import cloud.codestore.jsonapi.relationship.Relationship;
import cloud.codestore.jsonapi.resource.ResourceIdentifierObject;
import cloud.codestore.jsonapi.resource.ResourceObject;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(as=DeserializedToOneRelationship.class)
public class ToOneRelationship
extends Relationship {
    private ResourceIdentifierObject data;
    private ResourceObject relatedResource;

    public ToOneRelationship() {
    }

    public ToOneRelationship(String relatedResourceLink) {
        super(relatedResourceLink);
    }

    public ToOneRelationship(ResourceObject resourceObject) {
        this.setRelatedResource(resourceObject);
    }

    @JsonIgnore
    public ToOneRelationship setRelatedResource(ResourceObject resourceObject) {
        this.relatedResource = resourceObject;
        this.setData(resourceObject == null ? null : resourceObject.getIdentifier());
        return this;
    }

    @JsonIgnore
    public ResourceObject getRelatedResource() {
        return this.relatedResource;
    }

    @JsonIgnore
    public <T extends ResourceObject> T getRelatedResource(Class<T> type) {
        return (T)(this.relatedResource == null ? null : this.relatedResource);
    }

    @Override
    public boolean isIncluded() {
        return this.relatedResource != null;
    }

    @JsonGetter(value="data")
    public ResourceIdentifierObject getData() {
        return this.data;
    }

    @JsonSetter(value="data")
    public ToOneRelationship setData(ResourceIdentifierObject data) {
        if (this.relatedResource != null && data == null) {
            throw new IllegalStateException("Relationships that contain a related resource must contain a resource identifier object to provide resource linkage.");
        }
        this.data = data;
        return this;
    }
}

