/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.resource;

import cloud.codestore.jsonapi.document.JsonApiDocument;
import cloud.codestore.jsonapi.internal.VirtualAttributesWriter;
import cloud.codestore.jsonapi.internal.VirtualRelationshipsWriter;
import cloud.codestore.jsonapi.link.Link;
import cloud.codestore.jsonapi.link.LinksObject;
import cloud.codestore.jsonapi.meta.MetaInformation;
import cloud.codestore.jsonapi.relationship.ToOneRelationship;
import cloud.codestore.jsonapi.resource.ResourceIdentifierObject;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonAppend;

@JsonAppend(props={@JsonAppend.Prop(value=VirtualAttributesWriter.class, name="attributes"), @JsonAppend.Prop(value=VirtualRelationshipsWriter.class, name="relationships")})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true)
public abstract class ResourceObject {
    private String type;
    private String id;
    private LinksObject links = new LinksObject();
    private MetaInformation meta;
    private JsonApiDocument parent;

    public ResourceObject(String type) {
        if (type == null || type.isBlank()) {
            throw new IllegalArgumentException("Parameter 'type' must not be null or blank.");
        }
        this.type = type;
    }

    public ResourceObject(String type, String id) {
        this(type);
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Parameter 'id' must not be null or blank.");
        }
        this.id = id;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    void setId(String id) {
        this.id = id;
    }

    public ResourceObject setSelfLink(String self) {
        this.links.add(new Link("self", self));
        return this;
    }

    @JsonIgnore
    public String getSelfLink() {
        return this.links == null ? null : this.links.getSelfLink();
    }

    @JsonGetter(value="links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    public LinksObject getLinks() {
        return this.links;
    }

    @JsonGetter(value="meta")
    public MetaInformation getMeta() {
        return this.meta;
    }

    @JsonSetter(value="meta")
    public ResourceObject setMeta(MetaInformation meta) {
        this.meta = meta;
        return this;
    }

    public JsonApiDocument asDocument() {
        return JsonApiDocument.of(this);
    }

    public ToOneRelationship asRelationship() {
        return new ToOneRelationship(this);
    }

    @JsonIgnore
    public ResourceIdentifierObject getIdentifier() {
        return new ResourceIdentifierObject(this.type, this.id);
    }

    @JsonIgnore
    public JsonApiDocument getParent() {
        return this.parent;
    }

    @JsonIgnore
    public void setParent(JsonApiDocument parent) {
        this.parent = parent;
    }
}

