/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.annotations.AnnotationParser;
import cloud.commandframework.arguments.parser.ParserParameters;
import cloud.commandframework.meta.CommandMeta;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

class MetaFactory
implements Function<Annotation[], CommandMeta> {
    private final AnnotationParser<?> annotationParser;
    private final Function<ParserParameters, CommandMeta> metaMapper;

    MetaFactory(@NonNull AnnotationParser<?> annotationParser, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.annotationParser = annotationParser;
        this.metaMapper = metaMapper;
    }

    @Override
    public @NonNull CommandMeta apply(@NonNull Annotation @NonNull [] annotations) {
        ParserParameters parameters = ParserParameters.empty();
        for (Annotation annotation : annotations) {
            Function<Annotation, ParserParameters> function = this.annotationParser.getAnnotationMappers().get(annotation.annotationType());
            if (function == null) continue;
            parameters.merge(function.apply(annotation));
        }
        return this.metaMapper.apply(parameters);
    }
}

