/*
 * Decompiled with CFR 0.152.
 */
package cloud.liblibai.client;

import cloud.liblibai.openapi.client.ApiException;
import cloud.liblibai.openapi.client.api.DefaultApi;
import cloud.liblibai.openapi.client.model.ComfyRequest;
import cloud.liblibai.openapi.client.model.ComfyStatusRequest;
import cloud.liblibai.openapi.client.model.ComfyStatusResponse;
import cloud.liblibai.openapi.client.model.ComfyStatusResponseData;
import cloud.liblibai.openapi.client.model.GenerateStatus;
import cloud.liblibai.openapi.client.model.ImageToImageRequest;
import cloud.liblibai.openapi.client.model.StatusRequest;
import cloud.liblibai.openapi.client.model.StatusResponse;
import cloud.liblibai.openapi.client.model.StatusResponseData;
import cloud.liblibai.openapi.client.model.SubmitComfyResponse;
import cloud.liblibai.openapi.client.model.SubmitResponse;
import cloud.liblibai.openapi.client.model.TextToImageRequest;
import org.jetbrains.annotations.Nullable;

public class LibLib
extends DefaultApi {
    Integer queryStatusIntervalSeconds = 5;
    int toleratFailedQueryTimes = 5;

    public void setQueryStatusIntervalSeconds(Integer queryStatusInterval) {
        this.queryStatusIntervalSeconds = queryStatusInterval;
    }

    public Integer getQueryStatusIntervalSeconds() {
        return this.queryStatusIntervalSeconds;
    }

    public LibLib() {
        String accessKey = System.getenv().get("LIBLIB_ACCESS_KEY");
        String secretKey = System.getenv().get("LIBLIB_SECRET_KEY");
        if (accessKey == null || secretKey == null) {
            throw new RuntimeException("Not set LIBLIB_ACCESS_KEY or LIBLIB_SECRET_KEY");
        }
        this.getApiClient().setApiKeyPrefix(secretKey);
        this.getApiClient().setApiKey(accessKey);
    }

    public LibLib(String accessKey, String secretKey) {
        this.getApiClient().setApiKeyPrefix(secretKey);
        this.getApiClient().setApiKey(accessKey);
    }

    public StatusResponseData textToImage(TextToImageRequest request) throws ApiException {
        SubmitResponse submitResponse = this.submitTextToImage(request);
        if (submitResponse.getData() == null) {
            throw new ApiException(submitResponse.getCode(), "Error: " + submitResponse.getMsg());
        }
        String generateUuid = submitResponse.getData().getGenerateUuid();
        if (generateUuid == null) {
            throw new RuntimeException("Not fetch generate task uuid");
        }
        StatusResponse status = this.waitResult(generateUuid);
        return status.getData();
    }

    public StatusResponseData imageToImage(ImageToImageRequest request) throws ApiException {
        SubmitResponse submitResponse = this.submitImageToImage(request);
        if (submitResponse.getData() == null) {
            throw new ApiException(submitResponse.getCode(), "Error: " + submitResponse.getMsg());
        }
        String generateUuid = submitResponse.getData().getGenerateUuid();
        if (generateUuid == null) {
            throw new RuntimeException("Not fetch generate task uuid");
        }
        StatusResponse status = this.waitResult(generateUuid);
        return status.getData();
    }

    public ComfyStatusResponseData runComfy(ComfyRequest request) throws ApiException {
        SubmitComfyResponse submitComfyResponse = this.submitComfyTask(request);
        if (submitComfyResponse.getData() == null) {
            throw new ApiException(submitComfyResponse.getCode(), "Error: " + submitComfyResponse.getMsg());
        }
        String generateUuid = submitComfyResponse.getData().getGenerateUuid();
        if (generateUuid == null) {
            throw new RuntimeException("Not fetch generate task uuid");
        }
        ComfyStatusResponse status = this.waitComfy(generateUuid);
        return status.getData();
    }

    public ComfyStatusResponse waitComfy(String uuid) throws ApiException {
        int failedQueryTimes = 0;
        boolean isFinished = false;
        ComfyStatusResponse status = null;
        while (!isFinished && failedQueryTimes < this.toleratFailedQueryTimes) {
            status = this.getComfyStatus(new ComfyStatusRequest().generateUuid(uuid));
            if (status.getData() == null || status.getData().getGenerateStatus() == null) {
                ++failedQueryTimes;
                continue;
            }
            GenerateStatus generateStatus = status.getData().getGenerateStatus();
            switch (generateStatus) {
                case PENDING: 
                case RUNNING: 
                case GENERATED: 
                case APPROVING: {
                    break;
                }
                case SUCCEED: {
                    isFinished = true;
                    break;
                }
                case FAILED: {
                    isFinished = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected status " + (Object)((Object)generateStatus));
                }
            }
            try {
                Thread.sleep(this.queryStatusIntervalSeconds * 1000);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return status;
    }

    @Nullable
    public StatusResponse waitResult(String uuid) throws ApiException {
        int failedQueryTimes = 0;
        boolean isFinished = false;
        StatusResponse status = null;
        while (!isFinished && failedQueryTimes < this.toleratFailedQueryTimes) {
            status = this.getStatus(new StatusRequest().generateUuid(uuid));
            if (status.getData() == null || status.getData().getGenerateStatus() == null) {
                ++failedQueryTimes;
                continue;
            }
            GenerateStatus generateStatus = status.getData().getGenerateStatus();
            switch (generateStatus) {
                case PENDING: 
                case RUNNING: 
                case GENERATED: 
                case APPROVING: {
                    break;
                }
                case SUCCEED: {
                    isFinished = true;
                    break;
                }
                case FAILED: {
                    isFinished = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected status " + (Object)((Object)generateStatus));
                }
            }
            try {
                Thread.sleep(this.queryStatusIntervalSeconds * 1000);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return status;
    }
}

