/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.TestUtils;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class S3FeaturesTest {
    @Test
    public void testSetBucketLifecycle() throws Exception {
        AmazonS3 client = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        client.createBucket(bucketName);
        BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule().withId("expirationRule").withFilter(new LifecycleFilter((LifecycleFilterPredicate)new LifecycleTagPredicate(new Tag("deleted", "true")))).withExpirationInDays(3).withStatus("Enabled");
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration().withRules(new BucketLifecycleConfiguration.Rule[]{rule});
        client.setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
        bucketLifecycleConfiguration = client.getBucketLifecycleConfiguration(bucketName);
        Assert.assertNotNull((Object)bucketLifecycleConfiguration);
        Assert.assertEquals((Object)((BucketLifecycleConfiguration.Rule)bucketLifecycleConfiguration.getRules().get(0)).getId(), (Object)"expirationRule");
        client.deleteBucket(bucketName);
    }

    @Test
    public void testHttpsConnection() {
        if (!LocalstackTestRunner.useSSL()) {
            return;
        }
        TestUtils.disableSslCertChecking();
        String bucketName = "test-bucket-https";
        AmazonS3 amazonS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(LocalstackTestRunner.getEndpointS3(), LocalstackTestRunner.getDefaultRegion()))).withCredentials(TestUtils.getCredentialsProvider())).withChunkedEncodingDisabled(Boolean.valueOf(true))).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        ByteArrayInputStream is = new ByteArrayInputStream("test file content".getBytes());
        amazonS3Client.createBucket(bucketName);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "key1", (InputStream)is, new ObjectMetadata()).withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams("kmsKeyId"));
        PutObjectResult result = amazonS3Client.putObject(putObjectRequest);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getMetadata().getContentType());
        Assert.assertNotNull((Object)result.getMetadata().getETag());
    }

    @Test
    public void testMetadata() {
        AmazonS3 s3 = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        s3.createBucket(bucketName);
        String keyWithUnderscores = "__key1";
        String keyWithDashes = keyWithUnderscores.replace("_", "-");
        HashMap<String, String> originalMetadata = new HashMap<String, String>();
        originalMetadata.put(keyWithUnderscores, "val1");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setUserMetadata(originalMetadata);
        ByteArrayInputStream is = new ByteArrayInputStream("test-string".getBytes(StandardCharsets.UTF_8));
        s3.putObject(new PutObjectRequest(bucketName, "my-key1", (InputStream)is, objectMetadata));
        S3Object getObj = s3.getObject(new GetObjectRequest(bucketName, "my-key1"));
        ObjectMetadata objectMetadataResponse = getObj.getObjectMetadata();
        Map receivedMetadata = objectMetadataResponse.getUserMetadata();
        HashMap<String, String> actualResult = new HashMap<String, String>();
        actualResult.put(keyWithDashes, "val1");
        Assert.assertTrue((receivedMetadata.equals(originalMetadata) || receivedMetadata.equals(actualResult) ? 1 : 0) != 0);
    }
}

