/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.DockerTestUtils;
import cloud.localstack.TestUtils;
import cloud.localstack.docker.LocalstackDockerTestRunner;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackDockerTestRunner.class)
@LocalstackDockerProperties(randomizePorts=true)
public class BasicDockerFunctionalityTest {
    @Test
    public void testKinesis() throws Exception {
        AmazonKinesis kinesis = DockerTestUtils.getClientKinesis();
        ListStreamsResult streamsResult = kinesis.listStreams();
        Assert.assertThat((Object)streamsResult.getStreamNames().size(), (Matcher)Is.is((Object)0));
        CreateStreamRequest createStreamRequest = new CreateStreamRequest().withStreamName("test-stream").withShardCount(Integer.valueOf(2));
        kinesis.createStream(createStreamRequest);
        streamsResult = kinesis.listStreams();
        Assert.assertThat((Object)streamsResult.getStreamNames(), (Matcher)CoreMatchers.hasItem((Object)"test-stream"));
    }

    @Test
    public void testDynamo() throws Exception {
        AmazonDynamoDB dynamoDB = DockerTestUtils.getClientDynamoDb();
        ListTablesResult tablesResult = dynamoDB.listTables();
        Assert.assertThat((Object)tablesResult.getTableNames().size(), (Matcher)Is.is((Object)0));
        CreateTableRequest createTableRequest = new CreateTableRequest().withTableName("test.table").withKeySchema(new KeySchemaElement[]{new KeySchemaElement("identifier", KeyType.HASH)}).withAttributeDefinitions(new AttributeDefinition[]{new AttributeDefinition("identifier", ScalarAttributeType.S)}).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(10L), Long.valueOf(10L)));
        dynamoDB.createTable(createTableRequest);
        tablesResult = dynamoDB.listTables();
        Assert.assertThat((Object)tablesResult.getTableNames(), (Matcher)CoreMatchers.hasItem((Object)"test.table"));
    }

    @Test
    public void testS3() throws Exception {
        AmazonS3 client = DockerTestUtils.getClientS3();
        client.createBucket("test-bucket");
        List bucketList = client.listBuckets();
        Assert.assertThat((Object)bucketList.size(), (Matcher)Is.is((Object)1));
        File file = File.createTempFile("localstack", "s3");
        file.deleteOnExit();
        try (FileOutputStream stream = new FileOutputStream(file);){
            String content = "HELLO WORLD!";
            stream.write(content.getBytes());
        }
        PutObjectRequest request = new PutObjectRequest("test-bucket", "testData", file);
        client.putObject(request);
        ObjectListing listing = client.listObjects("test-bucket");
        Assert.assertThat((Object)listing.getObjectSummaries().size(), (Matcher)Is.is((Object)1));
        S3Object s3Object = client.getObject("test-bucket", "testData");
        String resultContent = IOUtils.toString((InputStream)s3Object.getObjectContent());
        Assert.assertThat((Object)resultContent, (Matcher)Is.is((Object)"HELLO WORLD!"));
    }

    @Test
    public void testSQS() throws Exception {
        AmazonSQS client = DockerTestUtils.getClientSQS();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("DelaySeconds", "0");
        attributeMap.put("MaximumMessageSize", "262144");
        attributeMap.put("MessageRetentionPeriod", "1209600");
        attributeMap.put("ReceiveMessageWaitTimeSeconds", "20");
        attributeMap.put("VisibilityTimeout", "30");
        CreateQueueRequest createQueueRequest = new CreateQueueRequest("test-queue").withAttributes(attributeMap);
        client.createQueue(createQueueRequest);
        ListQueuesResult listQueuesResult = client.listQueues();
        Assert.assertThat((Object)listQueuesResult.getQueueUrls().size(), (Matcher)Is.is((Object)1));
        SQSConnection connection = this.createSQSConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test-queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("Hello World!");
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage received = (TextMessage)consumer.receive();
        Assert.assertThat((Object)received.getText(), (Matcher)Is.is((Object)"Hello World!"));
    }

    private SQSConnection createSQSConnection() throws Exception {
        SQSConnectionFactory connectionFactory = SQSConnectionFactory.builder().withEndpoint(LocalstackDockerTestRunner.getEndpointSQS()).withAWSCredentialsProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(TestUtils.TEST_CREDENTIALS)).build();
        return connectionFactory.createConnection();
    }

    static {
        TestUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
    }
}

