/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.docker.Container;
import cloud.localstack.docker.annotation.IEnvironmentVariableProvider;
import cloud.localstack.docker.annotation.IHostNameResolver;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import cloud.localstack.docker.command.RegexStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class LocalstackDockerTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = Logger.getLogger(LocalstackDockerTestRunner.class.getName());
    private static final String PORT_CONFIG_FILENAME = "/opt/code/localstack/.venv/lib/python2.7/site-packages/localstack_client/config.py";
    private static final Pattern READY_TOKEN = Pattern.compile("Ready\\.");
    private static final Pattern DEFAULT_PORT_PATTERN = Pattern.compile("'(\\w+)'\\Q: '{proto}://{host}:\\E(\\d+)'");
    private static final int SERVICE_NAME_GROUP = 1;
    private static final int PORT_GROUP = 2;
    private static Container localStackContainer;
    private static Map<String, Integer> serviceToPortMap;
    private static String externalHostName;
    private static boolean pullNewImage;
    private static boolean randomizePorts;
    private static Map<String, String> environmentVariables;

    public static Container getLocalStackContainer() {
        return localStackContainer;
    }

    public LocalstackDockerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.processAnnotations(klass.getAnnotations());
    }

    private void processAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof LocalstackDockerProperties)) continue;
            this.processDockerPropertiesAnnotation((LocalstackDockerProperties)annotation);
        }
    }

    private void processDockerPropertiesAnnotation(LocalstackDockerProperties properties) {
        pullNewImage = properties.pullNewImage();
        randomizePorts = properties.randomizePorts();
        try {
            IHostNameResolver hostNameResolver = properties.hostNameResolver().newInstance();
            String resolvedName = hostNameResolver.getHostName();
            if (StringUtils.isNotBlank((CharSequence)resolvedName)) {
                externalHostName = resolvedName;
            }
            LOG.info("External host name is set to: " + externalHostName);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to resolve hostname", ex);
        }
        try {
            IEnvironmentVariableProvider environmentProvider = properties.environmentVariableProvider().newInstance();
            environmentVariables = environmentProvider.getEnvironmentVariables();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to get environment variables", ex);
        }
    }

    public void run(RunNotifier notifier) {
        LocalstackTestRunner.teardownInfrastructure();
        localStackContainer = Container.createLocalstackContainer(externalHostName, pullNewImage, randomizePorts, environmentVariables);
        try {
            this.loadServiceToPortMap();
            LOG.info("Waiting for localstack container to be ready...");
            localStackContainer.waitForLogToken(READY_TOKEN);
            super.run(notifier);
        }
        finally {
            localStackContainer.stop();
        }
    }

    private void loadServiceToPortMap() {
        String localStackPortConfig = localStackContainer.executeCommand(Arrays.asList("cat", PORT_CONFIG_FILENAME));
        Map<String, Integer> ports = new RegexStream(DEFAULT_PORT_PATTERN.matcher(localStackPortConfig)).stream().collect(Collectors.toMap(match -> match.group(1), match -> Integer.parseInt(match.group(2))));
        serviceToPortMap = Collections.unmodifiableMap(ports);
    }

    public static String getEndpointS3() {
        String s3Endpoint = LocalstackDockerTestRunner.endpointForService("s3");
        s3Endpoint = s3Endpoint.replace("localhost", "test.localhost.atlassian.io");
        return s3Endpoint;
    }

    public static String getEndpointKinesis() {
        return LocalstackDockerTestRunner.endpointForService("kinesis");
    }

    public static String getEndpointLambda() {
        return LocalstackDockerTestRunner.endpointForService("lambda");
    }

    public static String getEndpointDynamoDB() {
        return LocalstackDockerTestRunner.endpointForService("dynamodb");
    }

    public static String getEndpointDynamoDBStreams() {
        return LocalstackDockerTestRunner.endpointForService("dynamodbstreams");
    }

    public static String getEndpointAPIGateway() {
        return LocalstackDockerTestRunner.endpointForService("apigateway");
    }

    public static String getEndpointElasticsearch() {
        return LocalstackDockerTestRunner.endpointForService("elasticsearch");
    }

    public static String getEndpointElasticsearchService() {
        return LocalstackDockerTestRunner.endpointForService("es");
    }

    public static String getEndpointFirehose() {
        return LocalstackDockerTestRunner.endpointForService("firehose");
    }

    public static String getEndpointSNS() {
        return LocalstackDockerTestRunner.endpointForService("sns");
    }

    public static String getEndpointSQS() {
        return LocalstackDockerTestRunner.endpointForService("sqs");
    }

    public static String getEndpointRedshift() {
        return LocalstackDockerTestRunner.endpointForService("redshift");
    }

    public static String getEndpointSES() {
        return LocalstackDockerTestRunner.endpointForService("ses");
    }

    public static String getEndpointRoute53() {
        return LocalstackDockerTestRunner.endpointForService("route53");
    }

    public static String getEndpointCloudFormation() {
        return LocalstackDockerTestRunner.endpointForService("cloudformation");
    }

    public static String getEndpointCloudWatch() {
        return LocalstackDockerTestRunner.endpointForService("cloudwatch");
    }

    public static String getEndpointSSM() {
        return LocalstackDockerTestRunner.endpointForService("ssm");
    }

    public static String endpointForService(String serviceName) {
        if (serviceToPortMap == null) {
            throw new IllegalStateException("Service to port mapping has not been determined yet.");
        }
        if (!serviceToPortMap.containsKey(serviceName)) {
            throw new IllegalArgumentException("Unknown port mapping for service");
        }
        int internalPort = serviceToPortMap.get(serviceName);
        return LocalstackDockerTestRunner.endpointForPort(internalPort);
    }

    public static String endpointForPort(int port) {
        if (localStackContainer != null) {
            int externalPort = localStackContainer.getExternalPortFor(port);
            return String.format("http://%s:%s", externalHostName, externalPort);
        }
        throw new RuntimeException("Container not started");
    }

    static {
        externalHostName = "localhost";
        pullNewImage = true;
        randomizePorts = false;
        environmentVariables = new HashMap<String, String>();
    }
}

