/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.DockerTestUtils;
import cloud.localstack.docker.LocalstackDocker;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LocalstackDockerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void startup() {
        LocalstackDocker localstackDocker = LocalstackDocker.getLocalstackDocker();
        localstackDocker.setRandomizePorts(true);
        localstackDocker.startup();
        AmazonSQS amazonSQS = DockerTestUtils.getClientSQS();
        String queueUrl = amazonSQS.createQueue("test-queue").getQueueUrl();
        SendMessageResult sendMessageResult = amazonSQS.sendMessage(queueUrl, "test-message");
        Assert.assertNotNull((Object)sendMessageResult);
        String messageId = sendMessageResult.getMessageId();
        Assert.assertNotNull((Object)messageId);
        this.thrown.expect(IllegalStateException.class);
        localstackDocker.startup();
        localstackDocker.stop();
    }

    @Test
    public void stop() {
        LocalstackDocker localstackDocker = LocalstackDocker.getLocalstackDocker();
        localstackDocker.setRandomizePorts(true);
        localstackDocker.startup();
        localstackDocker.stop();
        AmazonSQS amazonSQS = DockerTestUtils.getClientSQS();
        this.thrown.expect(SdkClientException.class);
        amazonSQS.createQueue("test-queue").getQueueUrl();
    }

    @After
    public void tearDown() {
        LocalstackDocker.getLocalstackDocker().stop();
    }
}

