/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.Localstack;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TestUtils {
    public static final String DEFAULT_REGION = "us-east-1";
    public static final String TEST_ACCESS_KEY = "test";
    public static final String TEST_SECRET_KEY = "test";
    public static final AWSCredentials TEST_CREDENTIALS = new BasicAWSCredentials("test", "test");

    public static void setEnv(String key, String value) {
        HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.put(key, value);
        TestUtils.setEnv(newEnv);
    }

    public static AmazonSQS getClientSQS() {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambda getClientLambda() {
        return (AWSLambda)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonS3 getClientS3() {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationS3())).withCredentials(TestUtils.getCredentialsProvider());
        builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        return (AmazonS3)builder.build();
    }

    public static AWSSecretsManager getClientSecretsManager() {
        return (AWSSecretsManager)((AWSSecretsManagerClientBuilder)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSecretsManager())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesis getClientKinesis() {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider(TEST_CREDENTIALS);
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationLambda() {
        return TestUtils.getEndpointConfiguration(Localstack.getEndpointLambda());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationKinesis() {
        return TestUtils.getEndpointConfiguration(Localstack.getEndpointKinesis());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSQS() {
        return TestUtils.getEndpointConfiguration(Localstack.getEndpointSQS());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationS3() {
        return TestUtils.getEndpointConfiguration(Localstack.getEndpointS3());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSecretsManager() {
        return TestUtils.getEndpointConfiguration(Localstack.getEndpointSecretsmanager());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(String endpointURL) {
        return new AwsClientBuilder.EndpointConfiguration(endpointURL, DEFAULT_REGION);
    }

    protected static void setEnv(Map<String, String> newEnv) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newEnv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newEnv);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newEnv);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void disableSslCertChecking() {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
    }
}

