/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class LocalTestUtil {
    public static FunctionCode createFunctionCode(Class<?> clazz) throws Exception {
        FunctionCode code = new FunctionCode();
        ByteArrayOutputStream zipOut = new ByteArrayOutputStream();
        ByteArrayOutputStream jarOut = new ByteArrayOutputStream();
        ZipOutputStream zipStream = new ZipOutputStream(zipOut);
        JarOutputStream jarStream = new JarOutputStream(jarOut);
        LocalTestUtil.addClassToJar(clazz, jarStream);
        LocalTestUtil.addClassToJar(Record.class, jarStream);
        LocalTestUtil.addClassToJar(SQSEvent.class, jarStream);
        jarStream.close();
        ZipEntry zipEntry = new ZipEntry("LambdaCode.jar");
        zipStream.putNextEntry(zipEntry);
        zipStream.write(jarOut.toByteArray());
        zipStream.closeEntry();
        zipStream.close();
        code.setZipFile(ByteBuffer.wrap(zipOut.toByteArray()));
        return code;
    }

    private static void addClassToJar(Class<?> clazz, JarOutputStream jarStream) throws IOException {
        String resource = clazz.getName().replace(".", File.separator) + ".class";
        JarEntry jarEntry = new JarEntry(resource);
        jarStream.putNextEntry(jarEntry);
        IOUtils.copy((InputStream)LocalTestUtil.class.getResourceAsStream("/" + resource), (OutputStream)jarStream);
        jarStream.closeEntry();
    }
}

