/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.docker.Container;
import cloud.localstack.docker.annotation.LocalstackDockerConfiguration;
import cloud.localstack.docker.command.RegexStream;
import cloud.localstack.docker.exception.LocalstackDockerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LocalstackDocker {
    private static final Logger LOG = Logger.getLogger(LocalstackDocker.class.getName());
    private static final String PORT_CONFIG_FILENAME = "/opt/code/localstack/.venv/lib/python2.7/site-packages/localstack_client/config.py";
    private static final Pattern READY_TOKEN = Pattern.compile("Ready\\.");
    private static final Pattern DEFAULT_PORT_PATTERN = Pattern.compile("'(\\w+)'\\Q: '{proto}://{host}:\\E(\\d+)'");
    private static final int SERVICE_NAME_GROUP = 1;
    private static final int PORT_GROUP = 2;
    private Container localStackContainer;
    private static Map<String, Integer> serviceToPortMap;
    private static boolean locked;
    public static final LocalstackDocker INSTANCE;
    private String externalHostName;

    private LocalstackDocker() {
    }

    public void startup(LocalstackDockerConfiguration dockerConfiguration) {
        if (locked) {
            throw new IllegalStateException("A docker instance is starting or already started.");
        }
        locked = true;
        this.externalHostName = dockerConfiguration.getExternalHostName();
        try {
            this.localStackContainer = Container.createLocalstackContainer(dockerConfiguration.getExternalHostName(), dockerConfiguration.isPullNewImage(), dockerConfiguration.isRandomizePorts(), dockerConfiguration.getEnvironmentVariables());
            this.loadServiceToPortMap();
            LOG.info("Waiting for localstack container to be ready...");
            this.localStackContainer.waitForLogToken(READY_TOKEN);
        }
        catch (Exception t) {
            this.stop();
            throw new LocalstackDockerException("Could not start the localstack docker container.", t);
        }
    }

    public void stop() {
        if (this.localStackContainer != null) {
            this.localStackContainer.stop();
        }
        locked = false;
    }

    private void loadServiceToPortMap() {
        String localStackPortConfig = this.localStackContainer.executeCommand(Arrays.asList("cat", PORT_CONFIG_FILENAME));
        Map<String, Integer> ports = new RegexStream(DEFAULT_PORT_PATTERN.matcher(localStackPortConfig)).stream().collect(Collectors.toMap(match -> match.group(1), match -> Integer.parseInt(match.group(2))));
        serviceToPortMap = Collections.unmodifiableMap(ports);
    }

    public String getEndpointS3() {
        String s3Endpoint = this.endpointForService("s3");
        s3Endpoint = s3Endpoint.replace("localhost", "test.localhost.atlassian.io");
        return s3Endpoint;
    }

    public String getEndpointKinesis() {
        return this.endpointForService("kinesis");
    }

    public String getEndpointLambda() {
        return this.endpointForService("lambda");
    }

    public String getEndpointDynamoDB() {
        return this.endpointForService("dynamodb");
    }

    public String getEndpointDynamoDBStreams() {
        return this.endpointForService("dynamodbstreams");
    }

    public String getEndpointAPIGateway() {
        return this.endpointForService("apigateway");
    }

    public String getEndpointElasticsearch() {
        return this.endpointForService("elasticsearch");
    }

    public String getEndpointElasticsearchService() {
        return this.endpointForService("es");
    }

    public String getEndpointFirehose() {
        return this.endpointForService("firehose");
    }

    public String getEndpointSNS() {
        return this.endpointForService("sns");
    }

    public String getEndpointSQS() {
        return this.endpointForService("sqs");
    }

    public String getEndpointRedshift() {
        return this.endpointForService("redshift");
    }

    public String getEndpointSES() {
        return this.endpointForService("ses");
    }

    public String getEndpointRoute53() {
        return this.endpointForService("route53");
    }

    public String getEndpointCloudFormation() {
        return this.endpointForService("cloudformation");
    }

    public String getEndpointCloudWatch() {
        return this.endpointForService("cloudwatch");
    }

    public String getEndpointSSM() {
        return this.endpointForService("ssm");
    }

    public String getEndpointSecretsmanager() {
        return this.endpointForService("secretsmanager");
    }

    public String getEndpointStepFunctions() {
        return this.endpointForService("stepfunctions");
    }

    public String endpointForService(String serviceName) {
        if (serviceToPortMap == null) {
            throw new IllegalStateException("Service to port mapping has not been determined yet.");
        }
        if (!serviceToPortMap.containsKey(serviceName)) {
            throw new IllegalArgumentException("Unknown port mapping for service");
        }
        int internalPort = serviceToPortMap.get(serviceName);
        return this.endpointForPort(internalPort);
    }

    public String endpointForPort(int port) {
        if (this.localStackContainer != null) {
            int externalPort = this.localStackContainer.getExternalPortFor(port);
            return String.format("http://%s:%s", this.externalHostName, externalPort);
        }
        throw new RuntimeException("Container not started");
    }

    public Container getLocalStackContainer() {
        return this.localStackContainer;
    }

    static {
        locked = false;
        INSTANCE = new LocalstackDocker();
    }
}

