/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker.command;

import cloud.localstack.docker.command.Command;
import java.util.ArrayList;
import java.util.Map;

public class RunCommand
extends Command {
    private final String imageName;

    public RunCommand(String imageName) {
        this.imageName = imageName;
    }

    public String execute() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        args.add("-d");
        args.add("--rm");
        args.addAll(this.options);
        args.add(this.imageName);
        return this.dockerExe.execute(args);
    }

    public RunCommand withExposedPorts(String portsToExpose, boolean randomize) {
        String portsOption = String.format("%s:%s", randomize ? "" : portsToExpose, portsToExpose);
        this.addOptions("-p", portsOption);
        return this;
    }

    public RunCommand withEnvironmentVariable(String name, String value) {
        this.addEnvOption(name, value);
        return this;
    }

    public RunCommand withEnvironmentVariables(Map<String, String> environmentVariables) {
        environmentVariables.forEach((name, value) -> this.addEnvOption((String)name, (String)value));
        return this;
    }

    private void addEnvOption(String name, String value) {
        this.addOptions("-e", String.format("%s=%s", name, value));
    }
}

