/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LambdaContext;
import cloud.localstack.lambda.DDBEventParser;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.util.StringInputStream;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class LambdaExecutor {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java " + LambdaExecutor.class.getSimpleName() + " <lambdaClass> <recordsFilePath>");
            System.exit(1);
        }
        String fileContent = LambdaExecutor.readFile(args[1]);
        ObjectMapper reader = new ObjectMapper();
        Map map = (Map)reader.reader(Map.class).readValue(fileContent);
        List records = (List)LambdaExecutor.get(map, "Records");
        Map inputObject = map;
        if (records != null) {
            if (records.stream().filter(record -> record.containsKey("Kinesis")).count() > 0L) {
                KinesisEvent kinesisEvent = new KinesisEvent();
                inputObject = kinesisEvent;
                kinesisEvent.setRecords(new LinkedList());
                for (Map record2 : records) {
                    KinesisEvent.KinesisEventRecord r = new KinesisEvent.KinesisEventRecord();
                    kinesisEvent.getRecords().add(r);
                    KinesisEvent.Record kinesisRecord = new KinesisEvent.Record();
                    Map kinesis = (Map)LambdaExecutor.get(record2, "Kinesis");
                    String dataString = new String(LambdaExecutor.get(kinesis, "Data").toString().getBytes());
                    byte[] decodedData = Base64.getDecoder().decode(dataString);
                    kinesisRecord.setData(ByteBuffer.wrap(decodedData));
                    kinesisRecord.setPartitionKey((String)LambdaExecutor.get(kinesis, "PartitionKey"));
                    kinesisRecord.setApproximateArrivalTimestamp(new Date());
                    r.setKinesis(kinesisRecord);
                }
            } else if (records.stream().filter(record -> record.containsKey("Sns")).count() > 0L) {
                SNSEvent snsEvent = new SNSEvent();
                inputObject = snsEvent;
                snsEvent.setRecords(new LinkedList());
                for (Map record2 : records) {
                    SNSEvent.SNSRecord r = new SNSEvent.SNSRecord();
                    snsEvent.getRecords().add(r);
                    SNSEvent.SNS snsRecord = new SNSEvent.SNS();
                    Map sns = (Map)LambdaExecutor.get(record2, "Sns");
                    snsRecord.setMessage((String)LambdaExecutor.get(sns, "Message"));
                    snsRecord.setMessageAttributes((Map)LambdaExecutor.get(sns, "MessageAttributes"));
                    snsRecord.setType("Notification");
                    snsRecord.setTimestamp(new DateTime());
                    r.setSns(snsRecord);
                }
            } else if (records.stream().filter(record -> record.containsKey("dynamodb")).count() > 0L) {
                inputObject = DDBEventParser.parse(records);
            }
        }
        Object handler = LambdaExecutor.getHandler(args[0]);
        LambdaContext ctx = new LambdaContext();
        if (handler instanceof RequestHandler) {
            Object result = ((RequestHandler)handler).handleRequest((Object)inputObject, (Context)ctx);
            System.out.println(result);
        } else if (handler instanceof RequestStreamHandler) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ((RequestStreamHandler)handler).handleRequest((InputStream)new StringInputStream(fileContent), (OutputStream)os, (Context)ctx);
            System.out.println(os);
        }
    }

    private static Object getHandler(String handlerName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName(handlerName);
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> T get(Map<String, T> map, String key) {
        T result = map.get(key);
        if (result != null) {
            return result;
        }
        result = map.get(key = StringUtils.uncapitalize((String)key));
        if (result != null) {
            return result;
        }
        return map.get(key.toLowerCase());
    }

    public static String readFile(String file) throws Exception {
        if (!file.startsWith("/")) {
            file = System.getProperty("user.dir") + "/" + file;
        }
        return FileUtils.readFileToString((File)new File(file), (Charset)Charsets.UTF_8);
    }
}

