/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.lambda;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Identity;
import com.amazonaws.services.dynamodbv2.model.OperationType;
import com.amazonaws.services.dynamodbv2.model.StreamRecord;
import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.sun.javafx.fxml.expression.Expression;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class DDBEventParser {
    public static DynamodbEvent parse(List<Map<String, Object>> records) {
        DynamodbEvent dynamoDbEvent = new DynamodbEvent();
        dynamoDbEvent.setRecords(new LinkedList());
        for (Map<String, Object> record : records) {
            DynamodbEvent.DynamodbStreamRecord r = new DynamodbEvent.DynamodbStreamRecord();
            dynamoDbEvent.getRecords().add(r);
            r.setEventSourceARN((String)Expression.get(record, (String)"eventSourceARN"));
            r.setEventSource((String)Expression.get(record, (String)"eventSource"));
            r.setEventName(OperationType.fromValue((String)((String)Expression.get(record, (String)"eventName"))));
            r.setEventVersion((String)Expression.get(record, (String)"eventVersion"));
            r.setEventID((String)Expression.get(record, (String)"eventID"));
            r.setAwsRegion((String)Expression.get(record, (String)"awsRegion"));
            r.setUserIdentity((Identity)Expression.get(record, (String)"userIdentity"));
            Map ddbMap = (Map)record.get("dynamodb");
            StreamRecord streamRecord = new StreamRecord();
            r.setDynamodb(streamRecord);
            Date date = (Date)Expression.get((Object)ddbMap, (String)"approximateCreationDateTime");
            streamRecord.setApproximateCreationDateTime(date != null ? date : new Date());
            streamRecord.setSequenceNumber(UUID.randomUUID().toString());
            streamRecord.setKeys(DDBEventParser.fromSimpleMap((Map)Expression.get((Object)ddbMap, (String)"Keys")));
            streamRecord.setNewImage(DDBEventParser.fromSimpleMap((Map)Expression.get((Object)ddbMap, (String)"NewImage")));
            streamRecord.setOldImage(DDBEventParser.fromSimpleMap((Map)Expression.get((Object)ddbMap, (String)"OldImage")));
            streamRecord.setSizeBytes(Long.valueOf(((Integer)Expression.get((Object)ddbMap, (String)"SizeBytes")).longValue()));
            streamRecord.setStreamViewType((String)Expression.get((Object)ddbMap, (String)"StreamViewType"));
        }
        return dynamoDbEvent;
    }

    public static Map<String, AttributeValue> fromSimpleMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
        map.entrySet().stream().forEach(entry -> result.put((String)entry.getKey(), DDBEventParser.toAttributeValue(entry.getValue())));
        return result;
    }

    public static AttributeValue toAttributeValue(Object value) {
        AttributeValue result = new AttributeValue();
        if (value instanceof Map) {
            String key;
            Map.Entry entry = ((Map)value).entrySet().iterator().next();
            switch (key = (String)entry.getKey()) {
                case "M": {
                    Map in1 = (Map)entry.getValue();
                    result.setM(new LinkedHashMap());
                    in1.entrySet().stream().forEach(mapEntry -> result.addMEntry((String)mapEntry.getKey(), DDBEventParser.toAttributeValue(mapEntry.getValue())));
                    break;
                }
                case "SS": {
                    result.setSS((Collection)((List)entry.getValue()));
                    break;
                }
                case "BS": {
                    List in2 = (List)entry.getValue();
                    result.setBS((Collection)in2.stream().map(element -> ByteBuffer.wrap(element.getBytes())).collect(Collectors.toList()));
                    break;
                }
                case "NS": {
                    List in3 = (List)entry.getValue();
                    result.setNS((Collection)in3.stream().map(Object::toString).collect(Collectors.toList()));
                    break;
                }
                case "L": {
                    List in4 = (List)entry.getValue();
                    result.setL((Collection)in4.stream().map(el -> DDBEventParser.toAttributeValue(el)).collect(Collectors.toList()));
                    break;
                }
                case "NULL": {
                    result.withNULL(Boolean.valueOf(Boolean.parseBoolean(entry.getValue().toString())));
                    break;
                }
                case "BOOL": {
                    result.withBOOL(Boolean.valueOf(Boolean.parseBoolean(entry.getValue().toString())));
                    break;
                }
                case "S": {
                    result.withS((String)entry.getValue());
                    break;
                }
                case "N": {
                    String stringValue = entry.getValue().toString();
                    result.withN(stringValue);
                    break;
                }
                case "B": {
                    result.withBS(new ByteBuffer[]{ByteBuffer.wrap(entry.getValue().toString().getBytes())});
                    break;
                }
                default: {
                    result.setM(new LinkedHashMap());
                }
            }
        }
        return result;
    }
}

