/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.TestUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class S3UploadTest {
    @Test
    public void testTrival() throws Exception {
        this.testUpload("{}");
    }

    @Test
    public void testGreaterThan128k() throws Exception {
        this.testUpload(String.join((CharSequence)"", Collections.nCopies(13108, "abcdefghij")));
    }

    @Test
    public void testLessThan128k() throws Exception {
        this.testUpload(String.join((CharSequence)"", Collections.nCopies(13107, "abcdefghij")));
    }

    private void testUpload(String dataString) throws Exception {
        AmazonS3 client = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        String keyName = UUID.randomUUID().toString();
        client.createBucket(bucketName);
        byte[] dataBytes = dataString.getBytes(StandardCharsets.UTF_8);
        ObjectMetadata metaData = new ObjectMetadata();
        metaData.setContentType(ContentType.APPLICATION_JSON.toString());
        metaData.setContentEncoding(StandardCharsets.UTF_8.name());
        metaData.setContentLength((long)dataBytes.length);
        byte[] resultByte = DigestUtils.md5((byte[])dataBytes);
        String streamMD5 = new String(Base64.encodeBase64((byte[])resultByte));
        metaData.setContentMD5(streamMD5);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, keyName, (InputStream)new ByteArrayInputStream(dataBytes), metaData);
        client.putObject(putObjectRequest);
        S3Object object = client.getObject(bucketName, keyName);
        String returnedContent = IOUtils.toString((InputStream)object.getObjectContent(), (String)"utf-8");
        Assert.assertEquals((Object)streamMD5, (Object)object.getObjectMetadata().getContentMD5());
        Assert.assertEquals((Object)returnedContent, (Object)dataString);
        client.deleteObject(bucketName, keyName);
        client.deleteBucket(bucketName);
    }
}

