/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.TestUtils;
import cloud.localstack.docker.LocalstackDockerTestRunner;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import java.util.function.Supplier;

public class DockerTestUtils {
    public static AmazonSQS getClientSQS() {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withEndpointConfiguration(DockerTestUtils.createEndpointConfiguration(LocalstackDockerTestRunner::getEndpointSQS))).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambda getClientLambda() {
        return (AWSLambda)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withEndpointConfiguration(DockerTestUtils.createEndpointConfiguration(LocalstackDockerTestRunner::getEndpointLambda))).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonS3 getClientS3() {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(DockerTestUtils.createEndpointConfiguration(LocalstackDockerTestRunner::getEndpointS3))).withCredentials(TestUtils.getCredentialsProvider());
        builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        return (AmazonS3)builder.build();
    }

    public static AmazonKinesis getClientKinesis() {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withEndpointConfiguration(DockerTestUtils.createEndpointConfiguration(LocalstackDockerTestRunner::getEndpointKinesis))).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonDynamoDB getClientDynamoDb() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(DockerTestUtils.createEndpointConfiguration(LocalstackDockerTestRunner::getEndpointDynamoDB))).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    private static AwsClientBuilder.EndpointConfiguration createEndpointConfiguration(Supplier<String> supplier) {
        return TestUtils.getEndpointConfiguration(supplier.get());
    }
}

