/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalytics.model.CloudWatchLoggingOption;
import com.amazonaws.services.kinesisanalytics.model.Input;
import com.amazonaws.services.kinesisanalytics.model.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String applicationDescription;
    private List<Input> inputs;
    private List<Output> outputs;
    private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private String applicationCode;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CreateApplicationRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setApplicationDescription(String applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public CreateApplicationRequest withApplicationDescription(String applicationDescription) {
        this.setApplicationDescription(applicationDescription);
        return this;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<Input> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<Input>(inputs);
    }

    public CreateApplicationRequest withInputs(Input ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<Input>(inputs.length));
        }
        for (Input ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withInputs(Collection<Input> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public CreateApplicationRequest withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public List<CloudWatchLoggingOption> getCloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
        if (cloudWatchLoggingOptions == null) {
            this.cloudWatchLoggingOptions = null;
            return;
        }
        this.cloudWatchLoggingOptions = new ArrayList<CloudWatchLoggingOption>(cloudWatchLoggingOptions);
    }

    public CreateApplicationRequest withCloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
        if (this.cloudWatchLoggingOptions == null) {
            this.setCloudWatchLoggingOptions(new ArrayList<CloudWatchLoggingOption>(cloudWatchLoggingOptions.length));
        }
        for (CloudWatchLoggingOption ele : cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
        this.setCloudWatchLoggingOptions(cloudWatchLoggingOptions);
        return this;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public CreateApplicationRequest withApplicationCode(String applicationCode) {
        this.setApplicationCode(applicationCode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getApplicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(this.getApplicationDescription()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getCloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.getCloudWatchLoggingOptions()).append(",");
        }
        if (this.getApplicationCode() != null) {
            sb.append("ApplicationCode: ").append(this.getApplicationCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getApplicationDescription() == null ^ this.getApplicationDescription() == null) {
            return false;
        }
        if (other.getApplicationDescription() != null && !other.getApplicationDescription().equals(this.getApplicationDescription())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getCloudWatchLoggingOptions() == null ^ this.getCloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.getCloudWatchLoggingOptions() != null && !other.getCloudWatchLoggingOptions().equals(this.getCloudWatchLoggingOptions())) {
            return false;
        }
        if (other.getApplicationCode() == null ^ this.getApplicationCode() == null) {
            return false;
        }
        return other.getApplicationCode() == null || other.getApplicationCode().equals(this.getApplicationCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationDescription() == null ? 0 : this.getApplicationDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLoggingOptions() == null ? 0 : this.getCloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationCode() == null ? 0 : this.getApplicationCode().hashCode());
        return hashCode;
    }

    @Override
    public CreateApplicationRequest clone() {
        return (CreateApplicationRequest)super.clone();
    }
}

