/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.Localstack;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaAsync;
import com.amazonaws.services.lambda.AWSLambdaAsyncClientBuilder;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class TestUtils {
    public static final String DEFAULT_REGION = "us-east-1";
    public static final String TEST_ACCESS_KEY = "test";
    public static final String TEST_SECRET_KEY = "test";
    public static final AWSCredentials TEST_CREDENTIALS = new BasicAWSCredentials("test", "test");
    private static final String[] EXCLUDED_DIRECTORIES = new String[]{".github", ".git", ".idea", ".venv", "target", "node_modules"};

    public static void setEnv(String key, String value) {
        HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.put(key, value);
        TestUtils.setEnv(newEnv);
    }

    public static AmazonSQS getClientSQS() {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSQSAsync getClientSQSAsync() {
        return (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSQSAsync getClientSQSAsync(ExecutorFactory executorFactory) {
        return (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSQS())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNS getClientSNS() {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNSAsync getClientSNSAsync() {
        return (AmazonSNSAsync)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)AmazonSNSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonSNSAsync getClientSNSAsync(ExecutorFactory executorFactory) {
        return (AmazonSNSAsync)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)AmazonSNSAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSNS())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambda getClientLambda() {
        return (AWSLambda)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambdaAsync getClientLambdaAsync() {
        return (AWSLambdaAsync)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)AWSLambdaAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AWSLambdaAsync getClientLambdaAsync(ExecutorFactory executorFactory) {
        return (AWSLambdaAsync)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)((AWSLambdaAsyncClientBuilder)AWSLambdaAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationLambda())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonS3 getClientS3() {
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationS3())).withCredentials(TestUtils.getCredentialsProvider());
        builder.setPathStyleAccessEnabled(Boolean.valueOf(true));
        return (AmazonS3)builder.build();
    }

    public static AWSSecretsManager getClientSecretsManager() {
        return (AWSSecretsManager)((AWSSecretsManagerClientBuilder)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationSecretsManager())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonDynamoDB getClientDynamoDB() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationDynamoDB())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonDynamoDBStreams getClientDynamoDBStreams() {
        return (AmazonDynamoDBStreams)((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationDynamoDBStreams())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesis getClientKinesis() {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesisAsync getClientKinesisAsync() {
        return (AmazonKinesisAsync)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)AmazonKinesisAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    public static AmazonKinesisAsync getClientKinesisAsync(ExecutorFactory executorFactory) {
        return (AmazonKinesisAsync)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)((AmazonKinesisAsyncClientBuilder)AmazonKinesisAsyncClientBuilder.standard().withEndpointConfiguration(TestUtils.getEndpointConfigurationKinesis())).withExecutorFactory(executorFactory)).withCredentials(TestUtils.getCredentialsProvider())).build();
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationLambda() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointLambda());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationKinesis() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointKinesis());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationDynamoDB() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointDynamoDB());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationDynamoDBStreams() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointDynamoDBStreams());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSQS() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSQS());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationS3() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointS3());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSNS() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSNS());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationSecretsManager() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointSecretsmanager());
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfigurationStepFunctions() {
        return TestUtils.getEndpointConfiguration(Localstack.INSTANCE.getEndpointStepFunctions());
    }

    protected static void setEnv(Map<String, String> newEnv) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newEnv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newEnv);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newEnv);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void disableSslCertChecking() {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> {
                boolean isExcluded = Arrays.stream(EXCLUDED_DIRECTORIES).anyMatch(excluded -> source.toAbsolutePath().toString().contains((CharSequence)excluded));
                if (!isExcluded) {
                    TestUtils.copy(source, dest.resolve(src.relativize((Path)source)));
                }
            });
        }
    }

    public static void copy(Path source, Path dest) {
        block17: {
            try {
                CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
                if (Files.isDirectory(dest, new LinkOption[0])) {
                    return;
                }
                if (Files.exists(dest, new LinkOption[0])) {
                    try (FileChannel sourceFile = FileChannel.open(source, new OpenOption[0]);
                         FileChannel destFile = FileChannel.open(dest, new OpenOption[0]);){
                        if (!Files.getLastModifiedTime(source, new LinkOption[0]).equals(Files.getLastModifiedTime(dest, new LinkOption[0])) || sourceFile.size() != destFile.size()) {
                            Files.copy(source, dest, options);
                        }
                        break block17;
                    }
                }
                Files.copy(source, dest, options);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider(TEST_CREDENTIALS);
    }

    protected static AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(String endpointURL) {
        return new AwsClientBuilder.EndpointConfiguration(endpointURL, DEFAULT_REGION);
    }
}

