/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.docker.Container;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTest {
    private static final String EXTERNAL_HOST_NAME = "localhost";
    private static final String MY_PROPERTY = "MY_PROPERTY";
    private static final String MY_VALUE = "MyValue";
    private boolean pullNewImage = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createLocalstackContainer() throws Exception {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(MY_PROPERTY, MY_VALUE);
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)this.pullNewImage, (boolean)true, null, environmentVariables, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            ArrayList<String> echoDefaultEnv = this.buildEchoStatement("HOSTNAME_EXTERNAL");
            ArrayList<String> echoExternalEnv = this.buildEchoStatement(MY_PROPERTY);
            Assert.assertEquals((Object)EXTERNAL_HOST_NAME, (Object)localStackContainer.executeCommand(echoDefaultEnv));
            Assert.assertEquals((Object)MY_VALUE, (Object)localStackContainer.executeCommand(echoExternalEnv));
        }
        finally {
            localStackContainer.stop();
        }
    }

    private ArrayList<String> buildEchoStatement(String valueToEcho) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("bash");
        args.add("-c");
        args.add(String.format("echo $%s", valueToEcho));
        return args;
    }

    @Test
    public void createLocalstackContainerWithRandomPorts() throws Exception {
        Container container = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)this.pullNewImage, (boolean)true, null, null, null);
        try {
            container.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertNotEquals((long)4567L, (long)container.getExternalPortFor(4567));
            Assert.assertNotEquals((long)4575L, (long)container.getExternalPortFor(4575));
            Assert.assertNotEquals((long)4583L, (long)container.getExternalPortFor(4583));
            Assert.assertNotEquals((long)4584L, (long)container.getExternalPortFor(4584));
        }
        finally {
            container.stop();
        }
    }

    @Test
    public void createLocalstackContainerWithStaticPorts() throws Exception {
        Container container = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)this.pullNewImage, (boolean)false, null, null, null);
        try {
            container.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertEquals((long)4567L, (long)container.getExternalPortFor(4567));
            Assert.assertEquals((long)4575L, (long)container.getExternalPortFor(4575));
            Assert.assertEquals((long)4583L, (long)container.getExternalPortFor(4583));
            Assert.assertEquals((long)4584L, (long)container.getExternalPortFor(4584));
        }
        finally {
            container.stop();
        }
    }
}

