/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker.annotation;

import cloud.localstack.docker.annotation.IBindMountProvider;
import cloud.localstack.docker.annotation.IEnvironmentVariableProvider;
import cloud.localstack.docker.annotation.IHostNameResolver;
import cloud.localstack.docker.annotation.LocalstackDockerConfiguration;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class LocalstackDockerAnnotationProcessor {
    private static final Logger LOG = Logger.getLogger(LocalstackDockerAnnotationProcessor.class.getName());

    public LocalstackDockerConfiguration process(Class<?> klass) {
        return Stream.of(klass.getAnnotations()).filter(annotation -> annotation instanceof LocalstackDockerProperties).map(LocalstackDockerProperties.class::cast).map(this::processDockerPropertiesAnnotation).findFirst().orElse(LocalstackDockerConfiguration.DEFAULT);
    }

    private LocalstackDockerConfiguration processDockerPropertiesAnnotation(LocalstackDockerProperties properties) {
        return LocalstackDockerConfiguration.builder().environmentVariables(this.getEnvironments(properties)).bindMounts(this.getBindMounts(properties)).initializationToken(StringUtils.isEmpty((CharSequence)properties.initializationToken()) ? null : Pattern.compile(properties.initializationToken())).externalHostName(this.getExternalHostName(properties)).portMappings(this.getCustomPortMappings(properties)).pullNewImage(properties.pullNewImage()).ignoreDockerRunErrors(properties.ignoreDockerRunErrors()).randomizePorts(properties.randomizePorts()).imageName(StringUtils.isEmpty((CharSequence)properties.imageName()) ? null : properties.imageName()).imageTag(StringUtils.isEmpty((CharSequence)properties.imageTag()) ? null : properties.imageTag()).portEdge(this.getEnvOrDefault("LOCALSTACK_EDGE_PORT", properties.portEdge())).portElasticSearch(this.getEnvOrDefault("LOCALSTACK_ELASTICSEARCH_PORT", properties.portElasticSearch())).useSingleDockerContainer(properties.useSingleDockerContainer()).build();
    }

    private String getEnvOrDefault(String environmentVariable, String defaultValue) {
        return System.getenv().getOrDefault(environmentVariable, defaultValue);
    }

    private Map<Integer, Integer> getCustomPortMappings(LocalstackDockerProperties properties) {
        HashMap<Integer, Integer> portMappings = new HashMap<Integer, Integer>();
        for (String service : properties.services()) {
            String[] parts = service.split(":");
            if (parts.length <= 1) continue;
            int port = Integer.parseInt(parts[1]);
            portMappings.put(port, port);
        }
        return portMappings;
    }

    private Map<String, String> getEnvironments(LocalstackDockerProperties properties) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        try {
            IEnvironmentVariableProvider environmentProvider = properties.environmentVariableProvider().newInstance();
            environmentVariables.putAll(environmentProvider.getEnvironmentVariables());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to get environment variables", ex);
        }
        String services = String.join((CharSequence)",", properties.services());
        if (StringUtils.isNotEmpty((CharSequence)services)) {
            environmentVariables.put("SERVICES", services);
        }
        return environmentVariables;
    }

    private Map<String, String> getBindMounts(LocalstackDockerProperties properties) {
        try {
            IBindMountProvider environmentProvider = properties.bindMountProvider().newInstance();
            return new HashMap<String, String>((Map)environmentProvider.get());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to get bind mounts", ex);
        }
    }

    private String getExternalHostName(LocalstackDockerProperties properties) {
        try {
            IHostNameResolver hostNameResolver = properties.hostNameResolver().newInstance();
            String resolvedName = hostNameResolver.getHostName();
            String externalHostName = (String)StringUtils.defaultIfBlank((CharSequence)resolvedName, (CharSequence)"localhost");
            LOG.fine("External host name is set to: " + externalHostName);
            return externalHostName;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to resolve hostname", ex);
        }
    }
}

