/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.utils.PromiseAsyncHandler;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.PublishResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class SNSMessagingTest {
    private static final String TOPIC = "topic";

    @Test
    public void testSendMessage() throws JMSException {
        AmazonSNS clientSNS = TestUtils.getClientSNS();
        CreateTopicResult createTopicResult = clientSNS.createTopic(TOPIC);
        PublishResult publishResult = clientSNS.publish(createTopicResult.getTopicArn(), "message");
        Assert.assertNotNull((Object)publishResult);
    }

    @Test
    public void testSendMessageAsync() throws Exception {
        AmazonSNSAsync clientSNSAsync = TestUtils.getClientSNSAsync();
        PromiseAsyncHandler createTopicPromise = new PromiseAsyncHandler();
        clientSNSAsync.createTopicAsync(TOPIC, createTopicPromise);
        CompletionStage publishResult = createTopicPromise.thenCompose(createTopicResult -> {
            PromiseAsyncHandler publishPromise = new PromiseAsyncHandler();
            clientSNSAsync.publishAsync(createTopicResult.getTopicArn(), "message", publishPromise);
            return publishPromise;
        });
        PublishResult result = (PublishResult)((CompletableFuture)publishResult).get(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)result);
    }
}

