/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class KinesisConsumerTest {
    @Test
    public void testGetRecordCBOR() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        AmazonKinesisAsync kinesisClient = TestUtils.getClientKinesisAsync();
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(streamName);
        createStreamRequest.setShardCount(Integer.valueOf(1));
        kinesisClient.createStream(createStreamRequest);
        TimeUnit.SECONDS.sleep(2L);
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setPartitionKey("partitionkey");
        putRecordRequest.setStreamName(streamName);
        String message = "Hello world!";
        putRecordRequest.setData(ByteBuffer.wrap(message.getBytes()));
        String shardId = kinesisClient.putRecord(putRecordRequest).getShardId();
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
        getShardIteratorRequest.setShardId(shardId);
        getShardIteratorRequest.setShardIteratorType("TRIM_HORIZON");
        getShardIteratorRequest.setStreamName(streamName);
        String shardIterator = kinesisClient.getShardIterator(getShardIteratorRequest).getShardIterator();
        GetRecordsRequest getRecordRequest = new GetRecordsRequest();
        getRecordRequest.setShardIterator(shardIterator);
        getRecordRequest.setShardIterator(shardIterator);
        GetRecordsResult recordsResponse = kinesisClient.getRecords(getRecordRequest);
        List records = recordsResponse.getRecords().stream().map(r -> new String(r.getData().array())).collect(Collectors.toList());
        Assert.assertEquals((Object)message, records.get(0));
    }

    @Test
    public void testGetRecordJSON() throws Exception {
        System.setProperty("com.amazonaws.sdk.disableCbor", "true");
        this.testGetRecordCBOR();
        System.setProperty("com.amazonaws.sdk.disableCbor", "false");
    }
}

