/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker.command;

import cloud.localstack.docker.command.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RunCommand
extends Command {
    private static final int PULL_AND_RUN_TIMEOUT_MINUTES = 7;
    private final String imageName;
    private final String imageTag;

    public RunCommand(String imageName) {
        this(imageName, null);
    }

    public RunCommand(String imageName, String imageTag) {
        this.imageName = imageName;
        this.imageTag = imageTag;
    }

    public String execute() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        args.add("-d");
        args.add("--rm");
        args.addAll(this.options);
        args.add(this.imageTag == null ? this.imageName : String.format("%s:%s", this.imageName, this.imageTag));
        List<Integer> errorCodes = Arrays.asList(125, 126, 127);
        return this.dockerExe.execute(args, 7, errorCodes);
    }

    public RunCommand withExposedPorts(String portsToExpose, boolean randomize) {
        String[] parts = portsToExpose.split(":");
        String hostPort = randomize ? "" : (parts.length > 1 ? parts[0] : portsToExpose);
        String containerPort = parts.length > 1 ? parts[1] : portsToExpose;
        String portsOption = String.format("%s:%s", hostPort, containerPort);
        this.addOptions("-p", portsOption);
        return this;
    }

    public RunCommand withBindMountedVolumes(Map<String, String> hostToContainerMappings) {
        hostToContainerMappings.forEach((host, container) -> this.addOptions("-v", String.format("%s:%s", host, container)));
        return this;
    }

    public RunCommand withEnvironmentVariable(String name, String value) {
        this.addEnvOption(name, value);
        return this;
    }

    public RunCommand withEnvironmentVariables(Map<String, String> environmentVariables) {
        environmentVariables.forEach((name, value) -> this.addEnvOption((String)name, (String)value));
        return this;
    }

    public RunCommand withPlatform(String platform) {
        this.addOptions("--platform", platform);
        return this;
    }

    private void addEnvOption(String name, String value) {
        this.addOptions("-e", String.format("%s=%s", name, value));
    }
}

