/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.CommonUtils;
import cloud.localstack.docker.Container;
import cloud.localstack.docker.annotation.LocalstackDockerConfiguration;
import cloud.localstack.docker.command.RegexStream;
import cloud.localstack.docker.exception.LocalstackDockerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Localstack {
    public static final String ENV_CONFIG_USE_SSL = "USE_SSL";
    public static final String ENV_CONFIG_EDGE_PORT = "EDGE_PORT";
    public static final String INIT_SCRIPTS_PATH = "/docker-entrypoint-initaws.d";
    public static final String TMP_PATH = "/tmp/localstack";
    public static final int DEFAULT_EDGE_PORT = 4566;
    private static final Logger LOG = Logger.getLogger(Localstack.class.getName());
    private static final Pattern READY_TOKEN = Pattern.compile("Ready\\.");
    private static final String[] PYTHON_VERSIONS_FOLDERS = new String[]{"python3.8", "python3.7"};
    private static final String PORT_CONFIG_FILENAME = "/opt/code/localstack/.venv/lib/%s/site-packages/localstack_client/config.py";
    private static final Pattern DEFAULT_PORT_PATTERN = Pattern.compile("'(\\w+)'\\Q: '{proto}://{host}:\\E(\\d+)'");
    private Container localStackContainer;
    private boolean useEdgePortAsFallback = true;
    private static Map<String, Integer> serviceToPortMap;
    private static boolean locked;
    public static final Localstack INSTANCE;
    private String externalHostName;

    private Localstack() {
    }

    public void startup(LocalstackDockerConfiguration dockerConfiguration) {
        if (locked) {
            throw new IllegalStateException("A docker instance is starting or already started.");
        }
        locked = true;
        this.externalHostName = dockerConfiguration.getExternalHostName();
        Map<String, String> environmentVariables = dockerConfiguration.getEnvironmentVariables();
        environmentVariables = environmentVariables == null ? Collections.emptyMap() : environmentVariables;
        environmentVariables = new HashMap<String, String>(environmentVariables);
        Map<String, String> defaultEnvVars = this.getDefaultEnvironmentVariables();
        environmentVariables.putAll(defaultEnvVars);
        try {
            this.localStackContainer = Container.createLocalstackContainer(dockerConfiguration.getExternalHostName(), dockerConfiguration.isPullNewImage(), dockerConfiguration.isRandomizePorts(), dockerConfiguration.getImageName(), dockerConfiguration.getImageTag(), dockerConfiguration.getPortEdge(), dockerConfiguration.getPortElasticSearch(), environmentVariables, dockerConfiguration.getPortMappings(), dockerConfiguration.getBindMounts(), dockerConfiguration.getPlatform());
            this.loadServiceToPortMap();
            LOG.info("Waiting for LocalStack container to be ready...");
            this.localStackContainer.waitForLogToken(READY_TOKEN);
            if (dockerConfiguration.getInitializationToken() != null) {
                LOG.info("Waiting for LocalStack container to emit your initialization token '" + dockerConfiguration.getInitializationToken().toString() + "'...");
                this.localStackContainer.waitForLogToken(dockerConfiguration.getInitializationToken());
            }
        }
        catch (Exception t) {
            if ((t.toString().contains("port is already allocated") || t.toString().contains("address already in use")) && dockerConfiguration.isIgnoreDockerRunErrors()) {
                LOG.info("Ignoring port conflict when starting Docker container, due to ignoreDockerRunErrors=true");
                this.localStackContainer = Container.getRunningLocalstackContainer();
                this.loadServiceToPortMap();
                return;
            }
            this.stop();
            throw new LocalstackDockerException("Could not start the localstack docker container.", t);
        }
    }

    public void stop() {
        if (this.localStackContainer != null) {
            this.localStackContainer.stop();
        }
        locked = false;
    }

    public boolean isRunning() {
        return this.localStackContainer == null ? false : this.localStackContainer.isRunning();
    }

    private void loadServiceToPortMap() {
        try {
            this.doLoadServiceToPortMap();
        }
        catch (Exception e) {
            LOG.info("Ignoring error when fetching service ports -> using single edge port");
        }
    }

    private Map<String, String> getDefaultEnvironmentVariables() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.addEnvVariableIfDefined("LOCALSTACK_API_KEY", result);
        return result;
    }

    private void addEnvVariableIfDefined(String envVarName, Map<String, String> envVars) {
        String value = System.getenv(envVarName);
        if (value != null) {
            envVars.put(envVarName, value);
        }
    }

    private void doLoadServiceToPortMap() {
        String localStackPortConfig = "";
        for (int i = 0; i < PYTHON_VERSIONS_FOLDERS.length; ++i) {
            String filePath = String.format(PORT_CONFIG_FILENAME, PYTHON_VERSIONS_FOLDERS[i]);
            localStackPortConfig = this.localStackContainer.executeCommand(Arrays.asList("cat", filePath));
            if (localStackPortConfig.contains("No such container")) {
                localStackPortConfig = "";
                continue;
            }
            if (!localStackPortConfig.contains("No such file")) break;
            localStackPortConfig = "";
        }
        if (localStackPortConfig.isEmpty()) {
            throw new LocalstackDockerException("No config file found", new Exception());
        }
        int edgePort = this.getEdgePort();
        Map<String, Integer> ports = new RegexStream(DEFAULT_PORT_PATTERN.matcher(localStackPortConfig)).stream().collect(Collectors.toMap(match -> match.group(1), match -> edgePort));
        serviceToPortMap = Collections.unmodifiableMap(ports);
    }

    public String getEndpointS3() {
        String s3Endpoint = this.endpointForService("s3");
        s3Endpoint = s3Endpoint.replace("localhost", "localhost.localstack.cloud");
        return s3Endpoint;
    }

    public int getEdgePort() {
        String envEdgePort = System.getenv(ENV_CONFIG_EDGE_PORT);
        return envEdgePort == null ? 4566 : Integer.parseInt(envEdgePort);
    }

    public String getEndpointKinesis() {
        return this.endpointForService("kinesis");
    }

    public String getEndpointKMS() {
        return this.endpointForService("kms");
    }

    public String getEndpointLambda() {
        return this.endpointForService("lambda");
    }

    public String getEndpointDynamoDB() {
        return this.endpointForService("dynamodb");
    }

    public String getEndpointDynamoDBStreams() {
        return this.endpointForService("dynamodbstreams");
    }

    public String getEndpointAPIGateway() {
        return this.endpointForService("apigateway");
    }

    public String getEndpointElasticsearch() {
        return this.endpointForService("elasticsearch");
    }

    public String getEndpointElasticsearchService() {
        return this.endpointForService("es");
    }

    public String getEndpointFirehose() {
        return this.endpointForService("firehose");
    }

    public String getEndpointSNS() {
        return this.endpointForService("sns");
    }

    public String getEndpointSQS() {
        return this.endpointForService("sqs");
    }

    public String getEndpointRedshift() {
        return this.endpointForService("redshift");
    }

    public String getEndpointCloudWatch() {
        return this.endpointForService("cloudwatch");
    }

    public String getEndpointCloudWatchLogs() {
        return this.endpointForService("logs");
    }

    public String getEndpointSES() {
        return this.endpointForService("ses");
    }

    public String getEndpointRoute53() {
        return this.endpointForService("route53");
    }

    public String getEndpointCloudFormation() {
        return this.endpointForService("cloudformation");
    }

    public String getEndpointSSM() {
        return this.endpointForService("ssm");
    }

    public String getEndpointSecretsmanager() {
        return this.endpointForService("secretsmanager");
    }

    public String getEndpointEC2() {
        return this.endpointForService("ec2");
    }

    public String getEndpointStepFunctions() {
        return this.endpointForService("stepfunctions");
    }

    public String getEndpointIAM() {
        return this.endpointForService("iam");
    }

    public String getEndpointQLDB() {
        return this.endpointForService("qldb");
    }

    public String endpointForService(String serviceName) {
        return this.endpointForPort(this.getServicePort(serviceName));
    }

    public int getServicePort(String serviceName) {
        if (serviceToPortMap == null) {
            if (this.useEdgePortAsFallback) {
                return this.getEdgePort();
            }
            throw new IllegalStateException("Service to port mapping has not been determined yet.");
        }
        if (!serviceToPortMap.containsKey(serviceName)) {
            if (this.useEdgePortAsFallback) {
                return this.getEdgePort();
            }
            throw new IllegalArgumentException("Unknown port mapping for service: " + serviceName);
        }
        return serviceToPortMap.get(serviceName);
    }

    public String endpointForPort(int port) {
        if (this.localStackContainer != null) {
            int externalPort = this.localStackContainer.getExternalPortFor(port);
            String protocol = Localstack.useSSL() ? "https" : "http";
            return String.format("%s://%s:%s", protocol, this.externalHostName, externalPort);
        }
        throw new RuntimeException("Container not started");
    }

    public Container getLocalStackContainer() {
        return this.localStackContainer;
    }

    public static boolean useSSL() {
        return Localstack.isEnvConfigSet(ENV_CONFIG_USE_SSL);
    }

    public static boolean isEnvConfigSet(String configName) {
        String value = System.getenv(configName);
        return value != null && !Arrays.asList("false", "0", "").contains(value.trim());
    }

    public static String getDefaultRegion() {
        return "us-east-1";
    }

    static {
        locked = false;
        INSTANCE = new Localstack();
        CommonUtils.disableSslCertChecking();
    }
}

