/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker.annotation;

import cloud.localstack.docker.annotation.IEnvironmentVariableProvider;
import cloud.localstack.docker.annotation.IHostNameResolver;
import cloud.localstack.docker.annotation.LocalstackDockerConfiguration;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.thirdparty.apache.commons.lang3.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class LocalstackDockerAnnotationProcessor {
    private static final Logger LOG = Logger.getLogger(LocalstackDockerAnnotationProcessor.class.getName());

    public LocalstackDockerConfiguration process(Class<?> klass) {
        return Stream.of(klass.getAnnotations()).filter(annotation -> annotation instanceof LocalstackDockerProperties).map(i -> (LocalstackDockerProperties)i).map(this::processDockerPropertiesAnnotation).findFirst().orElse(LocalstackDockerConfiguration.DEFAULT);
    }

    private LocalstackDockerConfiguration processDockerPropertiesAnnotation(LocalstackDockerProperties properties) {
        return LocalstackDockerConfiguration.builder().environmentVariables(this.getEnvironments(properties)).externalHostName(this.getExternalHostName(properties)).portMappings(this.getCustomPortMappings(properties)).pullNewImage(properties.pullNewImage()).ignoreDockerRunErrors(properties.ignoreDockerRunErrors()).randomizePorts(properties.randomizePorts()).imageTag(StringUtils.isEmpty((CharSequence)properties.imageTag()) ? null : properties.imageTag()).useSingleDockerContainer(properties.useSingleDockerContainer()).build();
    }

    private Map<Integer, Integer> getCustomPortMappings(LocalstackDockerProperties properties) {
        HashMap<Integer, Integer> portMappings = new HashMap<Integer, Integer>();
        for (String service : properties.services()) {
            String[] parts = service.split(":");
            if (parts.length <= 1) continue;
            int port = Integer.parseInt(parts[1]);
            portMappings.put(port, port);
        }
        return portMappings;
    }

    private Map<String, String> getEnvironments(LocalstackDockerProperties properties) {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        try {
            IEnvironmentVariableProvider environmentProvider = properties.environmentVariableProvider().newInstance();
            environmentVariables.putAll(environmentProvider.getEnvironmentVariables());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to get environment variables", ex);
        }
        String services = String.join((CharSequence)",", properties.services());
        if (StringUtils.isNotEmpty((CharSequence)services)) {
            environmentVariables.put("SERVICES", services);
        }
        return environmentVariables;
    }

    private String getExternalHostName(LocalstackDockerProperties properties) {
        try {
            IHostNameResolver hostNameResolver = properties.hostNameResolver().newInstance();
            String resolvedName = hostNameResolver.getHostName();
            String externalHostName = (String)StringUtils.defaultIfBlank((CharSequence)resolvedName, (CharSequence)"localhost");
            LOG.fine("External host name is set to: " + externalHostName);
            return externalHostName;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Unable to resolve hostname", ex);
        }
    }
}

