/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LambdaContext;
import cloud.localstack.lambda.DDBEventParser;
import cloud.localstack.lambda.KinesisEventParser;
import cloud.localstack.lambda.S3EventParser;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.util.StringInputStream;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class LambdaExecutor {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java " + LambdaExecutor.class.getSimpleName() + " <lambdaClass> <recordsFilePath>");
            System.exit(1);
        }
        String fileContent = LambdaExecutor.readFile(args[1]);
        ObjectMapper reader = new ObjectMapper();
        reader.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        reader.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map map = (Map)reader.readerFor(Map.class).readValue(fileContent);
        List records = (List)LambdaExecutor.get(map, "Records");
        Object inputObject = map;
        Object handler = LambdaExecutor.getHandler(args[0]);
        if (records == null) {
            Optional<Object> deserialisedInput = LambdaExecutor.getInputObject(reader, fileContent, handler);
            if (deserialisedInput.isPresent()) {
                inputObject = deserialisedInput.get();
            }
        } else if (records.stream().anyMatch(record -> record.containsKey("kinesis") || record.containsKey("Kinesis"))) {
            inputObject = KinesisEventParser.parse(records);
        } else if (records.stream().anyMatch(record -> record.containsKey("Sns"))) {
            SNSEvent snsEvent = new SNSEvent();
            inputObject = snsEvent;
            snsEvent.setRecords(new LinkedList<SNSEvent.SNSRecord>());
            for (Map record2 : records) {
                SNSEvent.SNSRecord r = new SNSEvent.SNSRecord();
                snsEvent.getRecords().add(r);
                SNSEvent.SNS snsRecord = new SNSEvent.SNS();
                Map sns = (Map)LambdaExecutor.get(record2, "Sns");
                snsRecord.setMessage((String)LambdaExecutor.get(sns, "Message"));
                snsRecord.setMessageAttributes((Map)LambdaExecutor.get(sns, "MessageAttributes"));
                snsRecord.setType("Notification");
                snsRecord.setTimestamp(new DateTime());
                r.setSns(snsRecord);
            }
        } else if (records.stream().filter(record -> record.containsKey("dynamodb")).count() > 0L) {
            inputObject = DDBEventParser.parse(records);
        } else if (records.stream().anyMatch(record -> record.containsKey("s3"))) {
            inputObject = S3EventParser.parse(records);
        } else if (records.stream().anyMatch(record -> record.containsKey("sqs"))) {
            inputObject = reader.readValue(fileContent, SQSEvent.class);
        }
        LambdaContext ctx = new LambdaContext();
        if (handler instanceof RequestHandler) {
            Object result = ((RequestHandler)handler).handleRequest(inputObject, (Context)ctx);
            try {
                result = new ObjectMapper().writeValueAsString(result);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            System.out.println(result);
        } else if (handler instanceof RequestStreamHandler) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ((RequestStreamHandler)handler).handleRequest((InputStream)new StringInputStream(fileContent), (OutputStream)os, (Context)ctx);
            System.out.println(os);
        }
    }

    private static Optional<Object> getInputObject(ObjectMapper mapper, String objectString, Object handler) {
        Optional<Object> inputObject = Optional.empty();
        try {
            Optional<Type> handlerInterface = Arrays.stream(handler.getClass().getGenericInterfaces()).filter(genericInterface -> ((ParameterizedType)genericInterface).getRawType().equals(RequestHandler.class)).findFirst();
            if (handlerInterface.isPresent()) {
                Class<?> handlerInputType = Class.forName(((ParameterizedType)handlerInterface.get()).getActualTypeArguments()[0].getTypeName());
                inputObject = Optional.of(mapper.readerFor(handlerInputType).readValue(objectString));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputObject;
    }

    private static Object getHandler(String handlerName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName(handlerName);
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> T get(Map<String, T> map, String key) {
        T result = map.get(key);
        if (result != null) {
            return result;
        }
        result = map.get(key = StringUtils.uncapitalize((String)key));
        if (result != null) {
            return result;
        }
        return map.get(key.toLowerCase());
    }

    public static String readFile(String file) throws Exception {
        if (!file.startsWith("/")) {
            file = System.getProperty("user.dir") + "/" + file;
        }
        return Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8).collect(Collectors.joining());
    }
}

