/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;

@RunWith(value=LocalstackTestRunner.class)
public class BasicFeaturesSDKV2Test {
    @Test
    public void testCreateSqsQueueV2() throws Exception {
        String queueName = "test-q-" + UUID.randomUUID().toString();
        CreateQueueRequest request = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        SqsAsyncClient sqsClient = TestUtils.getClientSQSAsyncV2();
        CreateQueueResponse queue = (CreateQueueResponse)sqsClient.createQueue(request).get();
        Assert.assertTrue((boolean)queue.queueUrl().contains("000000000000/" + queueName));
    }

    @Test
    public void testCreateKinesisStreamV2() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCreateKinesisRecordV2() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
        SdkBytes payload = SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(String.format("testData-%d", 1).getBytes()));
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.streamName(streamName);
        putRecordRequest.data(payload);
        putRecordRequest.partitionKey(String.format("partitionKey-%d", 1));
        Assert.assertNotNull((Object)kinesisClient.putRecord((PutRecordRequest)putRecordRequest.build()));
    }

    @Test
    public void testS3CreateListBuckets() throws Exception {
        String bucketName = "test-b-" + UUID.randomUUID().toString();
        S3AsyncClient s3Client = TestUtils.getClientS3AsyncV2();
        CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        CreateBucketResponse response = (CreateBucketResponse)s3Client.createBucket(request).get();
        Assert.assertNotNull((Object)response);
        ListBucketsRequest listRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
        ListBucketsResponse buckets = (ListBucketsResponse)s3Client.listBuckets(listRequest).get();
        Bucket bucket = buckets.buckets().stream().filter(b -> b.name().equals(bucketName)).findFirst().get();
        Assert.assertNotNull((Object)bucket);
    }

    @Test
    public void testSendSNSMessage() throws Exception {
        String topicName = "test-t-" + UUID.randomUUID().toString();
        SnsAsyncClient clientSNS = TestUtils.getClientSNSAsyncV2();
        CreateTopicResponse createTopicResponse = (CreateTopicResponse)clientSNS.createTopic((CreateTopicRequest)CreateTopicRequest.builder().name(topicName).build()).get();
        String topicArn = createTopicResponse.topicArn();
        Assert.assertNotNull((Object)topicArn);
        PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().topicArn(topicArn).subject("test subject").message("message test.").build();
        PublishResponse publishResponse = (PublishResponse)clientSNS.publish(publishRequest).get();
        Assert.assertNotNull((Object)publishResponse.messageId());
    }

    @Test
    public void testGetSsmParameter() throws Exception {
        SsmAsyncClient clientSsm = TestUtils.getClientSSMAsyncV2();
        clientSsm.putParameter((PutParameterRequest)PutParameterRequest.builder().name("testparameter").value("testvalue").build());
        CompletableFuture getParameterResponse = clientSsm.getParameter((GetParameterRequest)GetParameterRequest.builder().name("testparameter").build());
        String parameterValue = ((GetParameterResponse)getParameterResponse.get()).parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"testvalue", (Object)parameterValue);
    }

    @Test
    public void testGetSecretsManagerSecret() throws Exception {
        SecretsManagerAsyncClient clientSecretsManager = TestUtils.getClientSecretsManagerAsyncV2();
        clientSecretsManager.createSecret((CreateSecretRequest)CreateSecretRequest.builder().name("testsecret").secretString("secretcontent").build());
        CompletableFuture getSecretResponse = clientSecretsManager.getSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId("testsecret").build());
        String secretValue = ((GetSecretValueResponse)getSecretResponse.get()).secretString();
        Assert.assertNotNull((Object)secretValue);
        Assert.assertEquals((Object)"secretcontent", (Object)secretValue);
    }

    @Test
    public void testGetSecretAsParam() throws Exception {
        SsmAsyncClient clientSsm = TestUtils.getClientSSMAsyncV2();
        SecretsManagerAsyncClient clientSecretsManager = TestUtils.getClientSecretsManagerAsyncV2();
        clientSecretsManager.createSecret((CreateSecretRequest)CreateSecretRequest.builder().name("testsecret").secretString("secretcontent").build()).join();
        CompletableFuture getParameterResponse = clientSsm.getParameter((GetParameterRequest)GetParameterRequest.builder().name("/aws/reference/secretsmanager/testsecret").build());
        String parameterValue = ((GetParameterResponse)getParameterResponse.get()).parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"secretcontent", (Object)parameterValue);
    }

    @Test
    public void testCWPutMetrics() throws Exception {
        CloudWatchAsyncClient clientCW = TestUtils.getClientCloudWatchAsyncV2();
        Dimension dimension = (Dimension)Dimension.builder().name("UNIQUE_PAGES").value("URLS").build();
        String time = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Instant instant = Instant.parse(time);
        double dataPoint = 1.23423;
        MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName("PAGES_VISITED").unit(StandardUnit.NONE).value(Double.valueOf(dataPoint)).timestamp(instant).dimensions(new Dimension[]{dimension}).build();
        PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace("SITE/TRAFFIC").metricData(new MetricDatum[]{datum}).build();
        PutMetricDataResponse response = (PutMetricDataResponse)clientCW.putMetricData(request).get();
        Assert.assertNotNull((Object)response);
    }

    static {
        System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
    }
}

