/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@RunWith(value=LocalstackTestRunner.class)
public class KinesisV2ConsumerTest {
    @Test
    public void testGetRecord() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
        TimeUnit.SECONDS.sleep(2L);
        PutRecordRequest putRecordRequest = (PutRecordRequest)PutRecordRequest.builder().partitionKey("partitionkey").streamName(streamName).data(SdkBytes.fromUtf8String((String)"hello, world!")).build();
        String shardId = ((PutRecordResponse)kinesisClient.putRecord(putRecordRequest).get()).shardId();
        GetShardIteratorRequest getShardIteratorRequest = (GetShardIteratorRequest)GetShardIteratorRequest.builder().shardId(shardId).shardIteratorType(ShardIteratorType.TRIM_HORIZON).streamName(streamName).build();
        String shardIterator = ((GetShardIteratorResponse)kinesisClient.getShardIterator(getShardIteratorRequest).get()).shardIterator();
        GetRecordsRequest getRecordRequest = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(shardIterator).build();
        Integer limit = 100;
        Integer counter = 0;
        Boolean recordFound = false;
        while (true) {
            GetRecordsResponse recordsResponse;
            if ((recordsResponse = (GetRecordsResponse)kinesisClient.getRecords(getRecordRequest).get()).hasRecords()) {
                recordFound = true;
                break;
            }
            if (counter >= limit) break;
            counter = counter + 1;
            shardIterator = recordsResponse.nextShardIterator();
        }
        Assert.assertTrue((boolean)recordFound);
    }
}

