/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.basecode;

import cloud.opencode.base.basecode.enums.ResultMessageEnum;
import cloud.opencode.base.basecode.enums.ResultStatusEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeResult<T>
implements Serializable {
    private static final long serialVersionUID = -4239977605869432973L;
    @Nullable
    private T data;
    @Nullable
    private Integer code;
    @Nullable
    private String message;
    private HttpStatus status;
    @Nullable
    private Long total;
    @Nullable
    private Long page;
    @Nullable
    private Long pageSize;
    @Nullable
    private HttpHeaders headers;
    private long timestamp;
    @Nullable
    private MediaType mediaType;

    public CodeResult(@Nullable HttpStatus status) {
        this.status = Objects.requireNonNullElse(status, HttpStatus.OK);
        this.data = null;
        this.code = ResultStatusEnum.SUCCESS.getCode();
        this.message = ResultMessageEnum.SYSTEM_OK.getValue();
        this.mediaType = null;
        this.headers = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
        this.timestamp = System.currentTimeMillis();
    }

    public CodeResult(@Nullable HttpStatus status, @Nullable T body) {
        this.status = Objects.requireNonNullElse(status, HttpStatus.OK);
        this.data = body;
        this.code = ResultStatusEnum.SUCCESS.getCode();
        this.message = ResultMessageEnum.SYSTEM_OK.getValue();
        this.mediaType = null;
        this.headers = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
        this.timestamp = System.currentTimeMillis();
    }

    public CodeResult(@Nullable HttpStatus status, @Nullable T body, @Nullable String message, @Nullable Integer code) {
        this.status = Objects.requireNonNullElse(status, HttpStatus.OK);
        this.data = body;
        this.code = Objects.requireNonNullElseGet(code, ResultStatusEnum.SUCCESS::getCode);
        this.message = Objects.requireNonNullElseGet(message, ResultMessageEnum.SYSTEM_OK::getValue);
        this.mediaType = null;
        this.headers = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
        this.timestamp = System.currentTimeMillis();
    }

    public CodeResult(@Nullable HttpStatus status, @Nullable T body, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        this.status = Objects.requireNonNullElse(status, HttpStatus.OK);
        this.data = body;
        this.code = ResultStatusEnum.SUCCESS.getCode();
        this.message = ResultMessageEnum.SYSTEM_OK.getValue();
        this.mediaType = type;
        this.headers = HttpHeaders.readOnlyHttpHeaders((MultiValueMap)(headers != null ? headers : new HttpHeaders()));
        this.total = null;
        this.page = null;
        this.pageSize = null;
        this.timestamp = System.currentTimeMillis();
    }

    public CodeResult(@Nullable HttpStatus status, @Nullable T body, @Nullable Long total, @Nullable Long page, @Nullable Long pageSize, @Nullable String message, @Nullable Integer code, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        this.status = Objects.requireNonNullElse(status, HttpStatus.OK);
        this.data = body;
        this.code = Objects.requireNonNullElseGet(code, ResultStatusEnum.SUCCESS::getCode);
        this.message = Objects.requireNonNullElseGet(message, ResultMessageEnum.SYSTEM_OK::getValue);
        this.mediaType = type;
        this.headers = HttpHeaders.readOnlyHttpHeaders((MultiValueMap)(headers != null ? headers : new HttpHeaders()));
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
        this.timestamp = System.currentTimeMillis();
    }

    public static CodeResult OK() {
        return new CodeResult(HttpStatus.OK);
    }

    public static <T> CodeResult OK(T data) {
        return new CodeResult<T>(HttpStatus.OK, data);
    }

    public static <T> CodeResult OK(T data, HttpStatus status) {
        return new CodeResult<T>(status, data);
    }

    public static <T> CodeResult OK(T data, String message) {
        return new CodeResult<T>(HttpStatus.OK, data, message, ResultStatusEnum.SUCCESS.getCode());
    }

    public static <T> CodeResult OK(T data, String message, HttpStatus status) {
        return new CodeResult<T>(status, data, message, ResultStatusEnum.SUCCESS.getCode());
    }

    public static <T> CodeResult OK(T data, String message, Integer code) {
        return new CodeResult<T>(HttpStatus.OK, data, message, code);
    }

    public static <T> CodeResult OK(T data, String message, Integer code, HttpStatus status) {
        return new CodeResult<T>(status, data, message, code);
    }

    public static <T> CodeResult OK(T data, MediaType type) {
        return new CodeResult<T>(null, data, type, null);
    }

    public static <T> CodeResult OK(T data, MediaType type, HttpStatus status) {
        return new CodeResult<T>(status, data, type, null);
    }

    public static <T> CodeResult OK(T data, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        return new CodeResult<T>(null, data, type, headers);
    }

    public static <T> CodeResult OK(T data, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers, HttpStatus status) {
        return new CodeResult<T>(status, data, type, headers);
    }

    public static <T> CodeResult OK(T data, Long total, Long page, Long pageSize) {
        return new CodeResult<T>(null, data, total, page, pageSize, null, null, null, null);
    }

    public static <T> CodeResult OK(T data, Long total, Long page, Long pageSize, String message, Integer code) {
        return new CodeResult<T>(null, data, total, page, pageSize, message, code, null, null);
    }

    public static <T> CodeResult OK(T data, Long total, Long page, Long pageSize, String message, Integer code, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        return new CodeResult<T>(null, data, total, page, pageSize, message, code, type, headers);
    }

    public static <T> CodeResult OKWithMediaTypeAndHeaders(T data, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers, HttpStatus status) {
        return new CodeResult<T>(status, data, type, headers);
    }

    public static <T> CodeResult OKWithMediaTypeAndHeaders(T data, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        return new CodeResult<T>(null, data, type, headers);
    }

    public static <T> CodeResult OKOnlyStatus(HttpStatus status) {
        return new CodeResult<T>(status);
    }

    public static <T> CodeResult OKWithoutStatus(T data) {
        CodeResult<T> codeResult = new CodeResult<T>(HttpStatus.OK, data);
        codeResult.setStatus(null);
        return codeResult;
    }

    public static CodeResult ERROR() {
        return new CodeResult<Object>(HttpStatus.BAD_REQUEST, null, ResultMessageEnum.SYSTEM_ERROR.getValue(), ResultStatusEnum.FAIL.getCode());
    }

    public static CodeResult ERROR(String message) {
        return new CodeResult<Object>(HttpStatus.BAD_REQUEST, null, message, ResultStatusEnum.FAIL.getCode());
    }

    public static CodeResult ERROR(HttpStatus status, String message) {
        return new CodeResult<Object>(status, null, message, ResultStatusEnum.FAIL.getCode());
    }

    public static CodeResult ERROR(HttpStatus status, String message, Integer code) {
        return new CodeResult<Object>(status, null, message, code);
    }

    public static CodeResult ERROR(HttpStatus status, @Nullable MediaType type, @Nullable MultiValueMap<String, String> headers) {
        return new CodeResult<Object>(status, null, type, headers);
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    @Nullable
    public Integer getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    @Nullable
    public Long getTotal() {
        return this.total;
    }

    @Nullable
    public Long getPage() {
        return this.page;
    }

    @Nullable
    public Long getPageSize() {
        return this.pageSize;
    }

    @Nullable
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setData(@Nullable T data) {
        this.data = data;
    }

    public void setCode(@Nullable Integer code) {
        this.code = code;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public void setStatus(HttpStatus status) {
        this.status = status;
    }

    public void setTotal(@Nullable Long total) {
        this.total = total;
    }

    public void setPage(@Nullable Long page) {
        this.page = page;
    }

    public void setPageSize(@Nullable Long pageSize) {
        this.pageSize = pageSize;
    }

    public void setHeaders(@Nullable HttpHeaders headers) {
        this.headers = headers;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setMediaType(@Nullable MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

