/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.basecode.handler;

import cloud.opencode.base.basecode.CodeException;
import cloud.opencode.base.basecode.CodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class CodeExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CodeExceptionHandler.class);

    @ExceptionHandler(value={IllegalArgumentException.class})
    public CodeResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"Params error", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.BAD_REQUEST, "Params error: " + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    public CodeResult handleSecurityException(SecurityException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"No access allowed", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.UNAUTHORIZED, "No access allowed: " + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    public CodeResult handleNullPointerException(NullPointerException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"Null pointer exception", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.INTERNAL_SERVER_ERROR, "Null pointer exception: " + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public CodeResult handleNoHandlerFoundException(NoHandlerFoundException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"Not found", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.NOT_FOUND, "Not found: " + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public CodeResult handleHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"Request type is not supported", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "Unsupported media type: " + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={CodeException.class})
    public CodeResult handleCodeException(CodeException e) {
        log.error("Error is: {}, Error Info: {}", (Object)e.getMessage(), (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.valueOf((int)e.getStatus().value()), e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public CodeResult handleRuntimeException(RuntimeException e) {
        log.error("Error is: {}, Error Info: {}", (Object)"Runtime exception", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public CodeResult handleException(Exception e) {
        log.error("Error is: {}, Error Info: {}", (Object)"System error", (Object)e.getLocalizedMessage());
        return CodeResult.ERROR(HttpStatus.INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
    }
}

