/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.basecode.handler;

import cloud.opencode.base.basecode.CodeException;
import cloud.opencode.base.basecode.CodeResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class CodeResponseHandler
implements ResponseBodyAdvice<Object> {
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> clazz) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> clazz, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof String) {
            return this.objectMapper.writeValueAsString((Object)CodeResult.OK(body));
        }
        if (body instanceof CodeResult) {
            MediaType responseMediaType;
            CodeResult result = (CodeResult)body;
            response.setStatusCode((HttpStatusCode)result.getStatus());
            result.setStatus(null);
            HttpHeaders headers = response.getHeaders();
            if (result.getHeaders() != null) {
                for (String key : result.getHeaders().keySet()) {
                    List values = result.getHeaders().get((Object)key);
                    if (values == null) continue;
                    for (String value : values) {
                        headers.set(key, value);
                    }
                }
                result.setHeaders(null);
            }
            if ((responseMediaType = result.getMediaType()) != null) {
                headers.setContentType(responseMediaType);
                if (this.isBinaryMediaType(responseMediaType)) {
                    OutputStream outputStream = response.getBody();
                    outputStream.write((byte[])result.getData());
                    outputStream.flush();
                    outputStream.close();
                }
                result.setMediaType(null);
            }
            return result;
        }
        if (body instanceof CodeException) {
            CodeException exception = (CodeException)body;
            response.setStatusCode(exception.getStatus());
            return exception;
        }
        return CodeResult.OK(body);
    }

    private boolean isBinaryMediaType(MediaType mediaType) {
        return mediaType == MediaType.APPLICATION_PDF || mediaType == MediaType.IMAGE_JPEG || mediaType == MediaType.IMAGE_PNG || mediaType == MediaType.IMAGE_GIF || mediaType == MediaType.APPLICATION_OCTET_STREAM;
    }
}

