/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.token.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class TokenConfig {
    @Bean
    @ConfigurationProperties(prefix="app.auth-token")
    public AuthToken apiToken() {
        return new AuthToken();
    }

    @Bean
    @ConfigurationProperties(prefix="app.auth-filter")
    public AuthFilter authFilter() {
        return new AuthFilter();
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    public static class AuthToken {
        private long expire;
        private String key = "";
        private String secret = "";

        public long getExpire() {
            return this.expire;
        }

        public String getKey() {
            return this.key;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setExpire(long expire) {
            this.expire = expire;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    public static class AuthFilter {
        private List<String> annoys = new ArrayList<String>();
        private List<String> auths = new ArrayList<String>();

        public List<String> getAnnoys() {
            return this.annoys;
        }

        public List<String> getAuths() {
            return this.auths;
        }

        public void setAnnoys(List<String> annoys) {
            this.annoys = annoys;
        }

        public void setAuths(List<String> auths) {
            this.auths = auths;
        }
    }
}

