/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.generator;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.joda.time.LocalDate;

public final class IdGenerator {
    private static final int CODE_LENGTH = 14;
    private static final long APP_BIT = 4L;
    private static final long MACHINE_BIT = 4L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MAX_MACHINE_NUM = 15L;
    private static final long MAX_APP_NUM = 15L;
    private static final long MACHINE_LEFT = 12L;
    private static final long APP_LEFT = 16L;
    private static final long TIME_LEFT = 20L;
    private static final String DATE_STRING = LocalDate.now().toString();
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final long START_TIMESTAMP = LocalDateTime.parse(DATE_STRING + " 00:00:00", DF).toInstant(ZoneOffset.of("+8")).toEpochMilli();
    private long appId;
    private long machineId;
    private long sequence = 0L;
    private long lastTimeStamp = -1L;
    private String appIdChar;
    private String machineChar;

    private IdGenerator() {
    }

    public IdGenerator(long appId, long machineId) {
        if (appId > 15L || appId < 0L) {
            throw new IllegalArgumentException("AppId can't be greater than 15 or less than 0\uff01");
        }
        if (machineId > 15L || machineId < 0L) {
            throw new IllegalArgumentException("MachineId can't be greater than 15 or less than 0\uff01");
        }
        this.appId = appId;
        this.machineId = machineId;
        this.appIdChar = Long.toString(appId, 16).toUpperCase();
        this.machineChar = Long.toString(machineId, 16).toUpperCase();
    }

    private long getNext() {
        long mill = this.getNew();
        while (mill <= this.lastTimeStamp) {
            mill = this.getNew();
        }
        return mill;
    }

    private long getNew() {
        return System.currentTimeMillis();
    }

    public synchronized String genId() {
        long currTimeStamp = this.getNew();
        if (currTimeStamp < this.lastTimeStamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currTimeStamp == this.lastTimeStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currTimeStamp = this.getNext();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeStamp = currTimeStamp;
        Long result = currTimeStamp - START_TIMESTAMP << 20 | this.appId << 16 | this.machineId << 12 | this.sequence;
        return DATE_STRING.replace("-", "") + this.appIdChar + this.machineChar + this.cast(result.toString());
    }

    private String cast(String StringNumber) {
        int len1 = StringNumber.length();
        if (len1 < 14) {
            return this.getZero(14 - len1) + StringNumber;
        }
        return StringNumber;
    }

    private String getZero(int x) {
        if (x <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < x; ++i) {
            sb.append(0);
        }
        return sb.toString();
    }
}

