/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.api.exception.handler;

import cn.jdevelops.api.exception.config.ExceptionConfig;
import cn.jdevelops.api.exception.exception.BusinessException;
import cn.jdevelops.api.result.custom.ExceptionResultWrap;
import cn.jdevelops.api.result.emums.ParamExceptionCode;
import cn.jdevelops.api.result.emums.PermissionsExceptionCode;
import cn.jdevelops.api.result.emums.ResultCode;
import cn.jdevelops.api.result.exception.ServiceException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    private static final String JSON_ERROR_INFO = "JSON parse error:";
    private static final String SEMICOLON = ";";
    private static final char BLANK = ' ';
    private static final int CUT_LENGTH = 100;
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String APPLICATION_JSON_UTF8_VALUE = "application/json;charset=UTF-8";
    @Resource
    private ExceptionConfig exceptionConfig;

    @ExceptionHandler(value={BusinessException.class})
    public Object handleBusinessException(BusinessException e, HttpServletResponse response) {
        this.responseConfig(response, e, e.getCode());
        return ExceptionResultWrap.result((Integer)e.getCode(), (String)e.getErrorMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public Object handleBusinessException(ServiceException e, HttpServletResponse response) {
        this.responseConfig(response, (Exception)e, e.getCode());
        return ExceptionResultWrap.result((Integer)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object exceptionHandler(NoHandlerFoundException e, HttpServletResponse response) {
        this.responseConfig(response, (Exception)e, PermissionsExceptionCode.AUTH_ERROR.getCode());
        return ExceptionResultWrap.result((Integer)PermissionsExceptionCode.AUTH_ERROR.getCode(), (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Object handleNullPointerException(NullPointerException e, HttpServletResponse response) {
        this.responseConfig(response, e, ResultCode.SYS_ERROR.getCode());
        return ExceptionResultWrap.result((Integer)ResultCode.SYS_ERROR.getCode(), (String)"\u6682\u65f6\u65e0\u6cd5\u83b7\u53d6\u6570\u636e");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e, HttpServletResponse response) {
        this.responseConfig(response, (Exception)e, ResultCode.SYS_ERROR.getCode());
        return ExceptionResultWrap.result((Integer)ResultCode.SYS_ERROR.getCode(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u5bf9 - get post ");
    }

    @ExceptionHandler
    public Object exceptionHandler(HttpMessageNotReadableException e, HttpServletResponse response) {
        String jsonErrorMsg;
        this.responseConfig(response, (Exception)e, ResultCode.SYS_ERROR.getCode());
        if (e.getLocalizedMessage().contains(JSON_ERROR_INFO) && Objects.nonNull(jsonErrorMsg = this.dealWithJsonExceptionError(e.getLocalizedMessage()))) {
            return ExceptionResultWrap.result((Integer)ParamExceptionCode.JSON_ERROR.getCode(), (String)("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u3002\u9519\u8bef\u6d88\u606f\uff1a" + jsonErrorMsg));
        }
        return ExceptionResultWrap.result((Integer)ParamExceptionCode.MESSAGE_NO_READING.getCode(), (String)("\u6d88\u606f\u4e0d\u53ef\u8bfb\uff1a" + StringUtils.substring((String)e.getMessage(), (int)0, (int)100)));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object exception(MethodArgumentNotValidException e, HttpServletResponse response) {
        this.responseConfig(response, (Exception)e, ResultCode.SYS_ERROR.getCode());
        BindingResult bindingResult = e.getBindingResult();
        List allErrors = bindingResult.getAllErrors();
        StringBuilder sb = new StringBuilder();
        allErrors.forEach(objectError -> {
            FieldError fieldError = (FieldError)objectError;
            sb.append(SEMICOLON).append(fieldError.getField()).append(":").append(fieldError.getDefaultMessage());
        });
        String message = sb.length() > 0 ? sb.substring(1) : sb.toString();
        return ExceptionResultWrap.result((Integer)ParamExceptionCode.CHECK_ERROR.getCode(), (String)message);
    }

    @ExceptionHandler(value={Exception.class})
    public Object handleException(Exception e, HttpServletResponse response) {
        this.responseConfig(response, e, ResultCode.SYS_ERROR.getCode());
        return ExceptionResultWrap.result((Exception)e);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Object handleRuntimeException(RuntimeException e, HttpServletResponse response) {
        this.responseConfig(response, e, ResultCode.SYS_ERROR.getCode());
        return ExceptionResultWrap.result((Exception)e);
    }

    @ExceptionHandler(value={BindException.class})
    public Object bindException(BindException e, HttpServletResponse response) {
        this.responseConfig(response, (Exception)e, ResultCode.SYS_ERROR.getCode());
        StringBuilder resqStr = new StringBuilder();
        e.getFieldErrors().forEach(it -> {
            resqStr.append("\u5b57\u6bb5:").append(it.getField()).append(" ==\u300b \u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u662f\uff1a").append(it.getDefaultMessage());
            resqStr.append("\u3002  ");
        });
        return ExceptionResultWrap.result((Integer)ResultCode.SYS_ERROR.getCode(), (String)resqStr.toString());
    }

    private String dealWithJsonExceptionError(String errorMsg) {
        int lastSemicolon = errorMsg.lastIndexOf(SEMICOLON);
        if (lastSemicolon != -1) {
            int startIndex;
            for (startIndex = lastSemicolon - 1; startIndex > 0 && errorMsg.charAt(startIndex) != ' '; --startIndex) {
            }
            return errorMsg.substring(++startIndex, lastSemicolon);
        }
        return null;
    }

    private void responseConfig(HttpServletResponse response, Exception e, int code) {
        if (this.exceptionConfig.getLogInput().booleanValue()) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (null == this.exceptionConfig.getHttpServletResponseHeaderContentType()) {
            response.setHeader(CONTENT_TYPE_HEADER_NAME, APPLICATION_JSON_UTF8_VALUE);
        } else {
            response.setHeader(CONTENT_TYPE_HEADER_NAME, this.exceptionConfig.getHttpServletResponseHeaderContentType());
        }
        if (this.exceptionConfig.getHttpServletResponseStatus().booleanValue()) {
            response.setStatus(code);
        }
    }
}

