/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.callback.AVServerDateCallback;
import com.avos.avoscloud.internal.AppConfiguration;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.internal.InternalDate;
import com.avos.avoscloud.internal.InternalLogger;
import com.avos.avoscloud.internal.InternalPersistence;
import com.avos.avoscloud.internal.InternalRequestSign;
import com.avos.avoscloud.internal.InternalSMS;
import com.avos.avoscloud.internal.MasterKeyConfiguration;
import com.avos.avoscloud.internal.impl.JavaAppConfiguration;
import com.avos.avoscloud.internal.impl.JavaRequestSignImplementation;
import com.avos.avoscloud.internal.impl.Log4j2Implementation;
import com.avos.avoscloud.internal.impl.SimplePersistence;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVOSCloud {
    static final String AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY = "AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY";
    static final String AV_CLOUD_CACHE_EXPIRE_DATE_KEY = "AV_CLOUD_CACHE_EXPIRE_DATE_KEY";
    static final Integer AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE = 30;
    static final String AV_CLOUD_CACHE_EXPIRE_KEY_ZONE = "AV_CLOUD_CACHE_EXPIRE_KEY_ZONE";
    static final String AV_CLOUD_API_VERSION_KEY_ZONE = "AV_CLOUD_API_VERSION_KEY_ZONE";
    static final String AV_CLOUD_API_VERSION_KEY = "AV_CLOUD_API_VERSION";

    public static void setNetworkTimeout(int timeoutInMills) {
        InternalConfigurationController.globalInstance().getClientConfiguration().setNetworkTimeoutInMills(timeoutInMills);
    }

    public static int getNetworkTimeout() {
        return InternalConfigurationController.globalInstance().getClientConfiguration().getNetworkTimeoutInMills();
    }

    private AVOSCloud() {
    }

    public static void initialize(String applicationId, String clientKey, String masterKey) {
        InternalConfigurationController.Builder builder = new InternalConfigurationController.Builder();
        builder.setAppConfiguration((AppConfiguration)JavaAppConfiguration.instance()).setInternalRequestSign((InternalRequestSign)JavaRequestSignImplementation.instance()).setInternalPersistence((InternalPersistence)SimplePersistence.instance()).setInternalLogger((InternalLogger)Log4j2Implementation.instance());
        builder.build();
        InternalConfigurationController.globalInstance().getAppConfiguration().setApplicationId(applicationId);
        InternalConfigurationController.globalInstance().getAppConfiguration().setClientKey(clientKey);
        if (InternalConfigurationController.globalInstance().getAppConfiguration() instanceof MasterKeyConfiguration) {
            ((MasterKeyConfiguration)InternalConfigurationController.globalInstance().getAppConfiguration()).setMasterKey(masterKey);
        }
    }

    public static void useAVCloudUS() {
        PaasClient.useAVCloudUS();
    }

    public static void useAVCloudCN() {
        PaasClient.useAVCloudCN();
    }

    public static boolean showInternalDebugLog() {
        return Log4j2Implementation.instance().showInternalDebugLog();
    }

    public static void setDebugLogEnabled(boolean enable) {
        Log4j2Implementation.instance().setDebugEnabled(enable);
    }

    public static boolean isDebugLogEnabled() {
        return Log4j2Implementation.instance().isDebugEnabled() || Log4j2Implementation.instance().showInternalDebugLog();
    }

    public static void requestSMSCode(String phone, String name, String op, int ttl) throws AVException {
        InternalSMS.requestSMSCode((String)phone, (String)name, (String)op, (int)ttl);
    }

    public static void requestSMSCode(String phone, String templateName, Map<String, Object> env) throws AVException {
        InternalSMS.requestSMSCode((String)phone, (String)templateName, env);
    }

    public static void requestSMSCode(String phone) throws AVException {
        InternalSMS.requestSMSCode((String)phone, null, null, (int)0);
    }

    public static void requestVoiceCode(String phoneNumber) throws AVException {
        InternalSMS.requestVoiceCode((String)phoneNumber, null);
    }

    public static void verifySMSCode(String code, String mobilePhoneNumber) throws AVException {
        InternalSMS.verifySMSCode((String)code, (String)mobilePhoneNumber);
    }

    public static void verifyCode(String code, String mobilePhoneNumber) throws AVException {
        InternalSMS.verifySMSCode((String)code, (String)mobilePhoneNumber);
    }

    public static Date getServerDate() throws AVException {
        return InternalDate.getServerDate();
    }

    public static void getServerDateInBackground(AVServerDateCallback callback) {
        InternalDate.getServerDateInBackground((AVServerDateCallback)callback);
    }

    public static void setShouldUseMasterKey(boolean should) {
        JavaRequestSignImplementation.instance().setUseMasterKey(should);
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    }
}

