/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal.impl;

import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.internal.InternalPersistence;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class SimplePersistence
implements InternalPersistence {
    private static SimplePersistence instance;
    private AVUser currentUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimplePersistence instance() {
        Class<SimplePersistence> clazz = SimplePersistence.class;
        synchronized (SimplePersistence.class) {
            if (instance == null) {
                instance = new SimplePersistence();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected SimplePersistence() {
    }

    public File getPaasDocumentDir() {
        return null;
    }

    public File getCacheDir() {
        return null;
    }

    public File getCommandCacheDir() {
        return null;
    }

    public boolean saveContentToFile(String content, File fileForSave) {
        return this.saveContentToFile(content.getBytes(), fileForSave);
    }

    public boolean saveContentToFile(byte[] content, File fileForSave) {
        boolean bl;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileForSave);
            fos.write(content);
            bl = true;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                AVUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        AVUtils.closeQuietly((Closeable)fos);
        return bl;
    }

    public void saveToDocumentDir(String content, String folderName, String fileName) {
        this.saveContentToFile(content.getBytes(), new File(folderName, fileName));
    }

    public String getFromDocumentDir(String folderName, String fileName) {
        return this.readContentFromFile(new File(folderName, fileName));
    }

    public String readContentFromFile(File fileForRead) {
        return new String(this.readContentBytesFromFile(fileForRead));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readContentBytesFromFile(File fileForRead) {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            int n;
            fis = new FileInputStream(fileForRead);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[5120];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                AVUtils.closeQuietly(fis);
                AVUtils.closeQuietly(bos);
                throw throwable;
            }
        }
        AVUtils.closeQuietly((Closeable)fis);
        AVUtils.closeQuietly((Closeable)bos);
        return buffer;
    }

    public void deleteFile(File file) {
        try {
            file.deleteOnExit();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void savePersistentSettingBoolean(String keyzone, String key, Boolean value) {
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key) {
        return false;
    }

    public boolean getPersistentSettingBoolean(String keyzone, String key, Boolean defaultValue) {
        return defaultValue;
    }

    public void savePersistentSettingInteger(String keyzone, String key, Integer value) {
    }

    public Integer getPersistentSettingInteger(String keyzone, String key, Integer defaultValue) {
        return defaultValue;
    }

    public Long getPersistentSettingLong(String keyzone, String key, Long defaultValue) {
        return defaultValue;
    }

    public void savePersistentSettingLong(String keyzone, String key, Long value) {
    }

    public void savePersistentSettingString(String keyzone, String key, String value) {
    }

    public String getPersistentSettingString(String keyzone, String key, String defaultValue) {
        return defaultValue;
    }

    public void removePersistentSettingString(String keyzone, String key) {
    }

    public String removePersistentSettingString(String keyzone, String key, String defaultValue) {
        return null;
    }

    public void removeKeyZonePersistentSettings(String keyzone) {
    }

    public String getAVFileCachePath() {
        return null;
    }

    public File getAVFileCacheFile(String url) {
        return null;
    }

    public void cleanAVFileCache(int days) {
    }

    public void setCurrentUser(AVUser user, boolean clean) {
        this.currentUser = user;
    }

    public <T extends AVUser> T getCurrentUser(Class<T> userClass) {
        if (this.currentUser != null) {
            return (T)AVUser.cast((AVUser)this.currentUser, userClass);
        }
        return null;
    }
}

