package cn.openjava.basic.crypto.factory;

import cn.openjava.basic.crypto.enums.CryptoType;

public class CryptoFactory {

    /**
     * 加密对象
     */
    private OpenJavaCrypto openJavaCrypto;

    /**
     * 空的构造方法
     */
    public CryptoFactory() {

    }

    /**
     * 创建实例
     *
     * @param cryptoType 加密类型
     * @return 加密对象
     */
    public OpenJavaCrypto newInstance(CryptoType cryptoType) {
        switch (cryptoType) {
            case SM2:
                return new Sm2Crypto();
            case SM234:
                return new Sm234Crypto();
            case BASE64:
                return new Base64Crypto();
        }
        return null;
    }

    /**
     * 获取加密对象
     *
     * @return 加密对象
     */
    public OpenJavaCrypto getInstance() {
        if (openJavaCrypto == null) {
            openJavaCrypto = newInstance(CryptoType.defaultType());
        }
        return openJavaCrypto;
    }

    /**
     * 获取加密对象
     *
     * @param cryptoType 解密类型
     * @return 加密结果
     */
    public OpenJavaCrypto getInstance(CryptoType cryptoType) {
        if (openJavaCrypto == null) {
            openJavaCrypto = newInstance(cryptoType);
        }
        return openJavaCrypto;
    }
}
