package cn.openjava.basic.format.message;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.experimental.Accessors;
import org.springframework.http.HttpStatus;

@Getter
@Accessors(fluent = true)
@AllArgsConstructor
public enum SecurityMessage implements IComplexMessage {
    /**
     * 安全校验失败
     */
    SECURITY_ERROR(HttpStatus.UNAUTHORIZED, MessageType.ERROR, 400, "安全校验失败"),
    /**
     * 登录认证未通过
     */
    SECURITY_NOT_AUTH(HttpStatus.UNAUTHORIZED, MessageType.ERROR, 401, "登录认证未通过"),
    /**
     * 不安全的HTTP方法
     */
    SECURITY_NOT_ALLOWED_HTTP_METHOD(HttpStatus.UNAUTHORIZED, MessageType.ERROR, 402, "不安全的HTTP方法"),
    /**
     * HTTP方法不被支持
     */
    METHOD_NOT_SUPPORTED(HttpStatus.UNAUTHORIZED, MessageType.ERROR, 403, "HTTP方法不被支持"),
    /**
     * 请求地址不存在
     */
    URL_NOT_FOUND(HttpStatus.NOT_FOUND, MessageType.ERROR, 404, "请求地址不存在");
    /**
     * http状态码
     */
    private final HttpStatus httpStatus;
    /**
     * 类型
     */
    private final MessageType type;

    /**
     * 消息编码
     */
    private final int code;
    /**
     * 消息内容
     */
    private final String message;
}
