/*
 * Decompiled with CFR 0.152.
 */
package co.convertloop.client;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.MissingFormatArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convertloop {
    private String appId;
    private String apiKey;
    private String baseUrl = "https://api.convertloop.co/";
    private String version = "v1";
    private final String LIB_VERSION = "java-0.1.0";

    public Convertloop(String appId, String apiKey, String version) throws Exception {
        this.appId = appId;
        this.apiKey = apiKey;
        this.version = version;
    }

    public String createOrUpdatePerson(HashMap<String, Object> data) throws Exception {
        if (data.get("pid") == null && data.get("user_id") == null && data.get("email") == null) {
            throw new MissingFormatArgumentException("You must supply at least one of the following keys: 'pid' (to update), or 'user_id' and/or 'email' (to create or update)");
        }
        Gson gson = new Gson();
        String json = gson.toJson(data);
        return this.post("/people", json);
    }

    public String sendEventLog(HashMap<String, Object> data) throws Exception {
        if (data.get("name") == null) {
            throw new MissingFormatArgumentException("No event name provided");
        }
        Gson gson = new Gson();
        String json = gson.toJson(data);
        return this.post("/event_logs", json);
    }

    public String post(String resource, String body) throws Exception {
        String output;
        StringBuilder result = new StringBuilder();
        URL url = new URL(this.baseUrl + this.version + resource);
        String authStr = this.appId + ":" + this.apiKey;
        String authEncoded = Base64.getEncoder().encodeToString(authStr.getBytes());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", "");
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Authorization", "Basic " + authEncoded);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("X-API-Source", "java-0.1.0");
        String jsonData = body;
        connection.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(jsonData);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((output = in.readLine()) != null) {
            result.append(output);
        }
        in.close();
        return result.toString();
    }
}

